/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.xforms.action.AbstractAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.Bind;
import de.betterform.xml.xforms.model.bind.Binding;
import de.betterform.xml.xforms.model.bind.BindingResolver;
import de.betterform.xml.xforms.model.bind.BindingUtil;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractBoundAction
extends AbstractAction
implements Binding {
    private static final Log LOGGER = LogFactory.getLog(AbstractBoundAction.class);
    private String instanceId;
    protected List nodeset;
    protected List evalInscopeContext;

    public AbstractBoundAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
    }

    @Override
    public List getNodeset() {
        return this.nodeset;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public String evalAttributeValueTemplates(String inputExpr, Element element) throws XFormsException {
        String toReplace = inputExpr;
        String value = "";
        StringBuffer substitutedString = new StringBuffer();
        boolean hasTokens = true;
        while (hasTokens) {
            int start = toReplace.indexOf("{");
            int end = toReplace.indexOf(125);
            if (start == -1 || end == -1) {
                hasTokens = false;
                substitutedString.append(toReplace);
                continue;
            }
            substitutedString.append(toReplace.substring(0, start));
            String valueTemplate = toReplace.substring(start + 1, end);
            if (valueTemplate.startsWith("$")) {
                valueTemplate = valueTemplate.substring(1);
                if (this.model.getContainer().getProcessor().getContext().containsKey(valueTemplate)) {
                    value = this.model.getContainer().getProcessor().getContext().get(valueTemplate).toString();
                }
            } else {
                value = XPathCache.getInstance().evaluateAsString(this.getNodeset(), this.getPosition(), valueTemplate, this.getPrefixMapping(), this.xpathFunctionContext);
            }
            if (value.equals("")) {
                LOGGER.warn((Object)("valueTemplate could not be evaluated. Replacing '" + valueTemplate + "' with empty string"));
            }
            substitutedString.append(value);
            toReplace = toReplace.substring(end + 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("inputExpr: " + inputExpr + " evaluated to: " + substitutedString));
        }
        return substitutedString.toString();
    }

    protected void updateXPathContext() throws XFormsException {
        this.evalInscopeContext = this.evalInScopeContext();
        String relativeExpr = this.getBindingExpression();
        try {
            this.nodeset = relativeExpr != null ? XPathCache.getInstance().evaluate(this.evalInscopeContext, 1, relativeExpr, this.getPrefixMapping(), this.xpathFunctionContext) : this.evalInscopeContext;
        }
        catch (XFormsException e) {
            throw new XFormsException(e);
        }
    }

    @Override
    public String getBindingExpression() {
        if (this.hasModelBinding()) {
            return this.getModelBinding().getBindingExpression();
        }
        if (BindingUtil.hasRef(this.element)) {
            return this.getXFormsAttribute("ref");
        }
        return this.getXFormsAttribute("nodeset");
    }

    @Override
    public String getBindingId() {
        String bindAttribute = this.getXFormsAttribute("bind");
        if (bindAttribute != null) {
            return bindAttribute;
        }
        return this.getId();
    }

    protected boolean hasModelBinding() {
        return this.getXFormsAttribute("bind") != null;
    }

    protected Bind getModelBinding() {
        String bindAttribute = this.getXFormsAttribute("bind");
        if (bindAttribute != null) {
            return (Bind)this.container.lookup(bindAttribute);
        }
        return null;
    }

    @Override
    public Binding getEnclosingBinding() {
        return this.getEnclosingBinding(this, true);
    }

    @Override
    public String getLocationPath() {
        return BindingResolver.getExpressionPath(this, this.repeatItemId);
    }

    @Override
    public String getModelId() {
        return this.getModel().getId();
    }

    @Override
    public boolean hasBindingExpression() {
        return this.getBindingExpression() != null || this.getContextExpression() != null;
    }

    @Override
    public String getInstanceId() throws XFormsException {
        if (this.instanceId == null) {
            this.instanceId = this.model.computeInstanceId(this.getLocationPath());
        }
        return this.instanceId;
    }

    public boolean setNodeValue(String value) throws XFormsException {
        Node node = XPathUtil.getAsNode(this.getNodeset(), this.getPosition());
        if (node == null) {
            return false;
        }
        this.model.getInstance(this.getInstanceId()).setNodeValue(node, value);
        return true;
    }
}

