/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.submission.AttributeOrValueChild;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DispatchAction
extends AbstractBoundAction {
    private static final Log LOGGER = LogFactory.getLog(DispatchAction.class);
    private AttributeOrValueChild eventName = null;
    private AttributeOrValueChild eventTarget = null;
    private AttributeOrValueChild delay = null;
    private boolean bubbles = true;
    private boolean cancelable = true;

    public DispatchAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        String cancelableAttribute;
        super.init();
        this.eventName = new AttributeOrValueChild(this.element, this.model, "name");
        this.eventName.init();
        this.eventTarget = new AttributeOrValueChild(this.element, this.model, "targetid");
        this.eventTarget.init();
        if (!this.eventTarget.isAvailable()) {
            throw new XFormsBindingException("missing targetid attribute or child at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, null);
        }
        String bubblesAttribute = this.getXFormsAttribute("bubbles");
        if (bubblesAttribute != null) {
            this.bubbles = Boolean.valueOf(bubblesAttribute);
        }
        if ((cancelableAttribute = this.getXFormsAttribute("cancelable")) != null) {
            this.cancelable = Boolean.valueOf(cancelableAttribute);
        }
        this.delay = new AttributeOrValueChild(this.element, this.model, "delay");
        this.delay.init();
    }

    @Override
    public void perform() throws XFormsException {
        if (this.delay.getValue() != null && this.delay.getValue() != "") {
            long sleep = Long.parseLong(this.delay.getValue());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("dispatch action - delaying for " + sleep + " milliseconds"));
            }
            try {
                Thread.sleep(sleep);
            }
            catch (Exception e) {
                throw new XFormsException(e);
            }
        }
        if (this.eventName != null) {
            NodeList nl = this.element.getElementsByTagNameNS("http://www.w3.org/2002/xforms", "contextinfo");
            int len = nl.getLength();
            if (len != 0) {
                this.updateXPathContext();
                Element e = null;
                HashMap<String, String> map = new HashMap<String, String>(len);
                for (int i = 0; i < len; ++i) {
                    e = (Element)nl.item(i);
                    String value = XPathCache.getInstance().evaluateAsString(this.getNodeset(), this.getPosition(), XFormsElement.getXFormsAttribute(e, "value"), this.getPrefixMapping(), this.xpathFunctionContext);
                    map.put(XFormsElement.getXFormsAttribute(e, "name"), value);
                }
                this.container.dispatch(this.eventTarget.getValue(), this.eventName.getValue(), map, this.bubbles, this.cancelable);
                return;
            }
            this.container.dispatch(this.eventTarget.getValue(), this.eventName.getValue(), null, this.bubbles, this.cancelable);
        }
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

