/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.connector.ConnectorFactory;
import de.betterform.connector.URIResolver;
import de.betterform.xml.config.Config;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.submission.AttributeOrValueChild;
import de.betterform.xml.xforms.ui.RepeatItem;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import de.betterform.xml.xslt.TransformerService;
import de.betterform.xml.xslt.impl.CachingTransformerService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.dom.DOMNodeWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import org.xml.sax.SAXException;

public class LoadAction
extends AbstractBoundAction {
    private static final Log LOGGER = LogFactory.getLog(LoadAction.class);
    private AttributeOrValueChild resource;
    private String showAttribute = null;
    private String targetAttribute = null;

    public LoadAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.resource = new AttributeOrValueChild(this.element, this.model, "resource");
        this.resource.init();
        this.showAttribute = this.getXFormsAttribute("show");
        if (this.showAttribute == null) {
            this.showAttribute = "replace";
        }
        this.targetAttribute = this.getXFormsAttribute("targetid");
    }

    @Override
    public void perform() throws XFormsException {
        String bindAttribute = this.getXFormsAttribute("bind");
        String refAttribute = this.getXFormsAttribute("ref");
        boolean includeCSS = true;
        boolean includeScript = true;
        Element extension = DOMUtil.findFirstChildNS(this.element, "http://www.w3.org/2002/xforms", "extension");
        if (extension != null) {
            includeCSS = "true".equalsIgnoreCase(LoadAction.getXFormsAttribute(extension, "includeCSS"));
            boolean bl = includeScript = "true".equalsIgnoreCase(LoadAction.getXFormsAttribute(extension, "includeScript"));
        }
        if (this.resource.isAvailable() && (bindAttribute != null || refAttribute != null)) {
            this.getLogger().warn((Object)(this + " perform: since both binding and linking attributes are present this action has no effect"));
            return;
        }
        String absoluteURI = null;
        try {
            String relativeURI;
            this.updateXPathContext();
            if ("none".equals(this.showAttribute)) {
                String evaluatedTarget = this.evalAttributeValueTemplates(this.targetAttribute, this.element);
                Element targetElem = this.getTargetElement(evaluatedTarget);
                this.destroyembeddedModels(targetElem);
                DOMUtil.removeAllChildren(targetElem);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("show", this.showAttribute);
                if (this.isRepeated()) {
                    map.put("nameTarget", evaluatedTarget);
                    String idForNamedElement = LoadAction.getXFormsAttribute(this.getTargetElement(evaluatedTarget), "id");
                    map.put("xlinkTarget", idForNamedElement);
                } else {
                    map.put("xlinkTarget", evaluatedTarget);
                }
                this.container.dispatch(this.target, "betterform-load-uri", map);
                return;
            }
            if (this.resource.isAvailable()) {
                relativeURI = this.resource.getValue();
            } else {
                if (this.nodeset == null || this.nodeset.size() == 0) {
                    this.getLogger().warn((Object)(this + " perform: nodeset '" + this.getLocationPath() + "' is empty"));
                    return;
                }
                Instance instance = this.model.getInstance(this.getInstanceId());
                relativeURI = instance.getNodeValue(XPathUtil.getAsNode(this.nodeset, 1));
            }
            absoluteURI = this.container.getConnectorFactory().getAbsoluteURI(relativeURI, this.element).toString();
            HashMap map = new HashMap();
            this.handleEmbedding(absoluteURI, map, includeCSS, includeScript);
        }
        catch (XFormsException e) {
            LOGGER.error((Object)("Error performing xf:load action at: " + DOMUtil.getCanonicalPath(this.getElement())));
            throw new XFormsException("Error performing xf:load action at: " + DOMUtil.getCanonicalPath(this.getElement()), e);
        }
    }

    private void handleEmbedding(String absoluteURI, HashMap map, boolean includeCSS, boolean includeScript) throws XFormsException {
        Element targetElem;
        Node embed;
        if (absoluteURI.indexOf("?") > 0) {
            String name = absoluteURI.substring(absoluteURI.indexOf("?") + 1);
            String value = name.substring(name.indexOf("=") + 1, name.length());
            name = name.substring(0, name.indexOf("="));
            this.container.getProcessor().setContextParam(name, value);
        }
        if (this.targetAttribute == null) {
            map.put("uri", absoluteURI);
            map.put("show", this.showAttribute);
            this.container.dispatch(this.target, "betterform-load-uri", (Object)map);
            return;
        }
        if (!"embed".equals(this.showAttribute)) {
            throw new XFormsException("@show must be 'embed' if @target is given but was: '" + this.showAttribute + "' on Element " + DOMUtil.getCanonicalPath(this.element));
        }
        String evaluatedTarget = this.evalAttributeValueTemplates(this.targetAttribute, this.element);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("targetid evaluated to: " + evaluatedTarget));
        }
        if ((embed = this.getEmbeddedDocument(absoluteURI)) == null) {
            map.put("resourceUri", absoluteURI);
            this.container.dispatch(this.target, "xforms-link-exception", (Object)map);
            return;
        }
        String utilizedEvents = this.getEventsInSubform(embed);
        String inlineCssRules = "";
        String externalCssRules = "";
        String inlineJavaScript = "";
        String externalJavaScript = "";
        if (includeCSS) {
            inlineCssRules = this.getInlineCSS(embed);
            externalCssRules = this.getExternalCSS(embed);
        }
        if (includeScript) {
            inlineJavaScript = this.getInlineJavaScript(embed);
            externalJavaScript = this.getExternalJavaScript(embed);
        }
        if (Config.getInstance().getProperty("webprocessor.doIncludes", "false").equals("true")) {
            embed = this.doIncludes(embed, absoluteURI);
        }
        embed = this.extractFragment(absoluteURI, embed);
        if (LOGGER.isDebugEnabled()) {
            DOMUtil.prettyPrintDOM(embed);
        }
        if ((targetElem = this.getTargetElement(evaluatedTarget)) != null) {
            if (targetElem.hasChildNodes()) {
                this.destroyembeddedModels(targetElem);
                Initializer.disposeUIElements(targetElem);
            }
            Element embeddedNode = (Element)this.container.getDocument().importNode(embed, true);
            NamespaceResolver.applyNamespaces(targetElem.getOwnerDocument().getDocumentElement(), embeddedNode);
            embeddedNode.setAttributeNS(null, "id", targetElem.getAttributeNS(null, "id"));
            DOMUtil.copyAttributes(targetElem, embeddedNode, null);
            targetElem.getParentNode().replaceChild(embeddedNode, targetElem);
            this.container.createEmbeddedForm(embeddedNode);
            this.container.dispatch((EventTarget)((Object)embeddedNode), "betterform-embed-done", (Object)map);
            if (this.getModel().isReady()) {
                map.put("uri", absoluteURI);
                map.put("show", this.showAttribute);
                map.put("targetElement", embeddedNode);
                map.put("nameTarget", evaluatedTarget);
                map.put("xlinkTarget", LoadAction.getXFormsAttribute(targetElem, "id"));
                map.put("inlineCSS", inlineCssRules);
                map.put("externalCSS", externalCssRules);
                map.put("inlineJavascript", inlineJavaScript);
                map.put("externalJavascript", externalJavaScript);
                map.put("utilizedEvents", utilizedEvents);
                this.container.dispatch((EventTarget)((Object)embeddedNode), "betterform-embed", (Object)map);
                this.container.dispatch(this.target, "betterform-load-uri", (Object)map);
            }
        } else {
            String message = "Element reference for targetid: " + this.targetAttribute + " not found. " + DOMUtil.getCanonicalPath(this.element);
            map.put("message", message);
            map.put("exceptionPath", DOMUtil.getCanonicalPath(this.element));
            this.container.dispatch(this.target, "betterform-exception", (Object)map);
        }
    }

    private String getEventsInSubform(Node embed) throws XFormsException {
        StringBuilder events;
        block16: {
            block15: {
                block14: {
                    events = new StringBuilder();
                    if (embed instanceof Document) {
                        embed = ((Document)embed).getDocumentElement();
                    }
                    try {
                        if (XPathUtil.evaluate((Element)embed, "//*[@ev:event eq 'xforms-select']").size() != 0) {
                            events.append("useXFSelect:true");
                        }
                    }
                    catch (Exception e) {
                        if (!LOGGER.isDebugEnabled()) break block14;
                        LOGGER.debug((Object)"no xforms-select event listener in form");
                    }
                }
                try {
                    if (XPathUtil.evaluate((Element)embed, "//*[@ev:event eq 'DOMFocusIn']").size() != 0) {
                        if (events.length() != 0) {
                            events.append(", useDOMFocusIN:true");
                        } else {
                            events.append("useDOMFocusIN:true");
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block15;
                    LOGGER.debug((Object)"no DOMFocusIn event listener in form");
                }
            }
            try {
                if (XPathUtil.evaluate((Element)embed, "//*[@ev:event eq 'DOMFocusOut']").size() != 0) {
                    if (events.length() != 0) {
                        events.append(", useDOMFocusOUT:true");
                    } else {
                        events.append("useDOMFocusOUT:true");
                    }
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block16;
                LOGGER.debug((Object)"no DOMFocusOut event listener in form");
            }
        }
        return events.toString();
    }

    private Node doIncludes(Node embed, String absoluteURI) {
        LOGGER.debug((Object)("LoadAction.doInclude: Node to embed: " + embed.toString() + " URI: " + absoluteURI));
        try {
            String uri = absoluteURI.substring(0, absoluteURI.lastIndexOf("/") + 1);
            CachingTransformerService transformerService = (CachingTransformerService)this.container.getProcessor().getContext().get(TransformerService.TRANSFORMER_SERVICE);
            Transformer transformer = transformerService.getTransformerByName("include.xsl");
            DOMSource source = new DOMSource(embed);
            DOMResult result = new DOMResult();
            transformer.setParameter("root", uri);
            transformer.transform(source, result);
            return result.getNode();
        }
        catch (TransformerException e) {
            LOGGER.debug((Object)"LoadAction.doInclude: TransformerException:", (Throwable)e);
            return embed;
        }
    }

    private String getInlineCSS(Node embed) throws XFormsException {
        List result;
        String cssRules = "";
        if (embed instanceof Document) {
            embed = ((Document)embed).getDocumentElement();
        }
        if ((result = XPathUtil.evaluate((Element)embed, "//*[@type eq 'text/css'][not(boolean(@href))]")).size() == 0) {
            return null;
        }
        for (int i = 0; i < result.size(); ++i) {
            Object item = result.get(i);
            if (!(result.get(i) instanceof DOMNodeWrapper)) continue;
            DOMNodeWrapper wrapper = (DOMNodeWrapper)item;
            Node n = (Node)wrapper.getUnderlyingNode();
            cssRules = cssRules + DOMUtil.getTextNodeAsString(n);
        }
        return cssRules;
    }

    private String getExternalCSS(Node embed) throws XFormsException {
        List result;
        String cssRules = "";
        if (embed instanceof Document) {
            embed = ((Document)embed).getDocumentElement();
        }
        if ((result = XPathUtil.evaluate((Element)embed, "//*[@type eq 'text/css'][boolean(@href)]")).size() == 0) {
            return null;
        }
        for (int i = 0; i < result.size(); ++i) {
            Object item = result.get(i);
            if (!(result.get(i) instanceof DOMNodeWrapper)) continue;
            DOMNodeWrapper wrapper = (DOMNodeWrapper)item;
            Node n = (Node)wrapper.getUnderlyingNode();
            cssRules = cssRules + n.getAttributes().getNamedItem("href").getNodeValue() + "#";
        }
        return cssRules;
    }

    private String getInlineJavaScript(Node embed) throws XFormsException {
        List result;
        String javaScriptCode = "";
        if (embed instanceof Document) {
            embed = ((Document)embed).getDocumentElement();
        }
        if ((result = XPathUtil.evaluate((Element)embed, "//*[not(namespace-uri() eq 'http://www.w3.org/2002/xforms')]/*[@type eq 'text/javascript'][not(boolean(@src))]")).size() == 0) {
            return null;
        }
        for (int i = 0; i < result.size(); ++i) {
            Object item = result.get(i);
            if (!(result.get(i) instanceof DOMNodeWrapper)) continue;
            DOMNodeWrapper wrapper = (DOMNodeWrapper)item;
            if ("action".equals(((DOMNodeWrapper)item).getParent().getLocalPart())) continue;
            Node n = (Node)wrapper.getUnderlyingNode();
            javaScriptCode = javaScriptCode + DOMUtil.getTextNodeAsString(n);
        }
        return javaScriptCode;
    }

    private String getExternalJavaScript(Node embed) throws XFormsException {
        String javaScriptCode = "";
        if (embed instanceof Document) {
            embed = ((Document)embed).getDocumentElement();
        }
        List result = XPathUtil.evaluate((Element)embed, "//*[@type eq 'text/javascript'][boolean(@src)]");
        for (int i = 0; i < result.size(); ++i) {
            Object item = result.get(i);
            if (!(result.get(i) instanceof DOMNodeWrapper)) continue;
            DOMNodeWrapper wrapper = (DOMNodeWrapper)item;
            Node n = (Node)wrapper.getUnderlyingNode();
            javaScriptCode = javaScriptCode + n.getAttributes().getNamedItem("src").getNodeValue() + "#";
        }
        return javaScriptCode;
    }

    private Element getTargetElement(String evaluatedTarget) throws XFormsException {
        Element targetElem = null;
        if (this.isRepeated()) {
            String itemId = this.getRepeatItemId();
            RepeatItem item = (RepeatItem)this.container.lookup(itemId);
            int pos = item.getPosition();
            targetElem = (Element)XPathUtil.evaluateAsSingleNode(item.getElement().getOwnerDocument(), "//*[@name eq '" + evaluatedTarget + "']");
        } else {
            targetElem = this.container.getElementById(evaluatedTarget);
        }
        return targetElem;
    }

    private Node getEmbeddedDocument(String absoluteURI) throws XFormsException {
        ConnectorFactory factory = ConnectorFactory.getFactory();
        factory.setContext(this.container.getProcessor().getContext());
        URIResolver uriResolver = factory.createURIResolver(absoluteURI, this.element);
        Object answer = uriResolver.resolve();
        Node embed = null;
        if (answer instanceof Node) {
            embed = (Node)answer;
        } else if (answer instanceof String) {
            try {
                embed = DOMUtil.parseString((String)answer, true, false);
            }
            catch (ParserConfigurationException e) {
                throw new XFormsException(e);
            }
            catch (IOException e) {
                throw new XFormsException(e);
            }
            catch (SAXException e) {
                throw new XFormsException(e);
            }
        }
        return embed;
    }

    private Node extractFragment(String absoluteURI, Node embed) throws XFormsException {
        if (embed instanceof Document && absoluteURI.indexOf("#") != -1) {
            String s = absoluteURI.substring(absoluteURI.indexOf("#") + 1);
            if (s.indexOf("?") != -1) {
                s = s.substring(0, s.indexOf("?"));
            }
            embed = DOMUtil.getById((Document)embed, s);
        }
        if (embed == null) {
            throw new XFormsException("content returned from URI could not be recognized");
        }
        if (embed instanceof Document) {
            embed = ((Document)embed).getDocumentElement();
        }
        return embed;
    }

    private void destroyembeddedModels(Element targetElem) throws XFormsException {
        NodeList childNodes = targetElem.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (node.getNodeType() != 1) continue;
            Element elementImpl = (Element)node;
            String name = elementImpl.getLocalName();
            String uri = elementImpl.getNamespaceURI();
            if ("http://www.w3.org/2002/xforms".equals(uri) && name.equals("model")) {
                Model model = (Model)elementImpl.getUserData("");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("dispatch 'model-destruct' event to embedded model: " + model.getId()));
                }
                String modelId = model.getId();
                model.dispose();
                this.container.removeModel(model);
                model = null;
                if (!Config.getInstance().getProperty("betterform.debug-allowed").equals("true")) continue;
                HashMap<String, String> contextInfo = new HashMap<String, String>(1);
                contextInfo.put("modelId", modelId);
                this.container.dispatch(this.target, "betterform-model-removed", contextInfo);
                continue;
            }
            this.destroyembeddedModels(elementImpl);
        }
    }

    @Override
    public boolean hasBindingExpression() {
        return this.getBindingExpression() != null || this.resource.isAvailable();
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    private void storeInContext(String uri, String show) {
        this.container.getProcessor().getContext().put("betterform.load.URI", uri);
        this.container.getProcessor().getContext().put("betterform.load.target", show);
    }
}

