/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.action.AbstractBoundAction;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.Repeat;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class SetIndexAction
extends AbstractBoundAction {
    private static Log LOGGER = LogFactory.getLog(SetIndexAction.class);
    private String indexAttribute;
    private String repeatAttribute;

    public SetIndexAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.repeatAttribute = this.getXFormsAttribute("repeat");
        if (this.repeatAttribute == null) {
            throw new XFormsBindingException("missing repeat attribute at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, null);
        }
        this.indexAttribute = this.getXFormsAttribute("index");
        if (this.indexAttribute == null) {
            throw new XFormsBindingException("missing index attribute at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, null);
        }
    }

    @Override
    public void perform() throws XFormsException {
        XFormsElement repeatObject = this.container.lookup(this.repeatAttribute);
        if (repeatObject == null || !(repeatObject instanceof Repeat)) {
            throw new XFormsBindingException("invalid repeat id at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, (Object)this.repeatAttribute);
        }
        Repeat repeat = (Repeat)repeatObject;
        List resultNodeset = this.evalInScopeContext();
        String relativeExpr = this.indexAttribute;
        String result = relativeExpr.equals("last()") ? resultNodeset.size() + "" : XPathCache.getInstance().evaluateAsString(resultNodeset, this.getPosition(), relativeExpr, this.getPrefixMapping(), this.xpathFunctionContext);
        double value = Double.NaN;
        if (result != null) {
            value = Double.valueOf(result);
        }
        if (Double.isNaN(value)) {
            this.getLogger().warn((Object)(this + " perform: expression '" + this.indexAttribute + "' does not evaluate to an integer"));
            return;
        }
        long index = Math.round(value);
        if (index < 1L) {
            repeat.setIndex(1);
            this.container.dispatch(repeat.getTarget(), "xforms-scroll-first", null);
        } else if (index > (long)repeat.getContextSize()) {
            index = repeat.getContextSize();
            repeat.setIndex((int)index);
            this.container.dispatch(repeat.getTarget(), "xforms-scroll-last", null);
        } else {
            repeat.setIndex((int)index);
        }
        this.doRebuild(true);
        this.doRecalculate(true);
        this.doRevalidate(true);
        this.doRefresh(true);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

