/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.action;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.action.AbstractAction;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.submission.AttributeOrValueChild;
import de.betterform.xml.xforms.ui.Case;
import de.betterform.xml.xforms.ui.RepeatItem;
import de.betterform.xml.xforms.ui.Switch;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ToggleAction
extends AbstractAction {
    private static final Log LOGGER = LogFactory.getLog(ToggleAction.class);
    private AttributeOrValueChild caseId = null;

    public ToggleAction(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.caseId = new AttributeOrValueChild(this.element, this.model, "case");
        this.caseId.init();
    }

    @Override
    public void perform() throws XFormsException {
        String evaluatedCaseId = this.caseId.getValue();
        Object caseObject = null;
        if (this.isRepeated()) {
            caseObject = null;
            RepeatItem repeatItem = (RepeatItem)this.container.lookup(this.getRepeatItemId());
            Node caseNode = XPathUtil.getAsNode(XPathUtil.evaluate(repeatItem.getElement(), ".//*[@caseId eq '" + this.caseId.getValue() + "']"), 1);
            if (caseNode != null) {
                caseObject = caseNode.getUserData("");
            }
        }
        if (caseObject == null) {
            caseObject = this.container.lookup(evaluatedCaseId);
        }
        if (caseObject == null || !(caseObject instanceof Case)) {
            throw new XFormsBindingException("invalid case id at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, (Object)evaluatedCaseId);
        }
        Case toSelect = (Case)caseObject;
        Switch switchElement = toSelect.getSwitch();
        Case isSelected = switchElement.getSelected();
        if (!toSelect.getId().equals(isSelected.getId())) {
            isSelected.deselect();
        }
        if (!isSelected.getId().equals(toSelect.getId())) {
            toSelect.select();
        }
        if (!toSelect.getId().equals(isSelected.getId())) {
            this.container.dispatch(isSelected.getTarget(), "xforms-deselect", null);
        }
        if (!isSelected.getId().equals(toSelect.getId())) {
            this.container.dispatch(toSelect.getTarget(), "xforms-select", null);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("selected", toSelect.getId());
        map.put("deselected", isSelected.getId());
        this.container.dispatch(switchElement.getTarget(), "betterform-switch-toggled", map);
        this.doRefresh(true);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

