/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.exception.XFormsLinkException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.XercesElementImpl;
import de.betterform.xml.xforms.model.XercesNodeImpl;
import de.betterform.xml.xforms.model.bind.BindingResolver;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import de.betterform.xml.xpath.XPathUtil;
import de.betterform.xml.xpath.impl.saxon.BetterFormXPathContext;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.om.NodeInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;

public class Instance
extends XFormsElement {
    private static Log LOGGER = LogFactory.getLog(Instance.class);
    private Document instanceDocument = null;
    private Element initialInstance = null;
    private BetterFormXPathContext xPathContext = null;
    private static String READONLY_INSTANCE = "readonly";
    private boolean isReadonly = false;

    public Instance(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        if (this.getXFormsAttribute(READONLY_INSTANCE) != null && this.getXFormsAttribute(READONLY_INSTANCE).equals("true")) {
            this.isReadonly = true;
        }
        this.initialInstance = this.createInitialInstance();
        this.instanceDocument = this.createInstanceDocument();
        this.storeContainerRef();
        this.registerId();
        this.initXPathContext();
    }

    private void initXPathContext() {
        this.xPathContext = new BetterFormXPathContext(this.getInstanceNodeset(), 1, this.getPrefixMapping(), this.xpathFunctionContext);
    }

    public BetterFormXPathContext getRootContext() {
        return this.xPathContext;
    }

    boolean isReadOnly() {
        return this.isReadonly;
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.initialInstance = null;
        this.instanceDocument = null;
    }

    public ModelItem getModelItem(String locationPath) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)(this + " get model item for locationPath '" + locationPath + "'"));
        }
        if (!this.existsNode(locationPath)) {
            return null;
        }
        Node node = this.getNode(locationPath);
        ModelItem item = (ModelItem)node.getUserData("");
        if (item == null) {
            item = Instance.createModelItem(node);
        }
        return item;
    }

    public Iterator iterateModelItems() throws XFormsException {
        return this.iterateModelItems(this.getInstanceNodeset(), 1, "/", Collections.EMPTY_MAP, null, true);
    }

    public Iterator iterateModelItems(List nodeset, boolean deep) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < nodeset.size(); ++i) {
            Node node = de.betterform.xml.xpath.impl.saxon.XPathUtil.getAsNode(nodeset, i + 1);
            this.listModelItems(list, node, deep);
        }
        return list.iterator();
    }

    public Iterator iterateModelItems(List nodeset, int position, String path, Map prefixMapping, XPathFunctionContext functionContext, boolean deep) throws XFormsException {
        List xpathResult = XPathCache.getInstance().evaluate(nodeset, position, path, prefixMapping, functionContext);
        return this.iterateModelItems(xpathResult, deep);
    }

    public String getNodeValue(Node node) throws XFormsException {
        ModelItem modelItem = this.getModelItem(node);
        if (modelItem == null) {
            throw new XFormsException("model item for path '" + DOMUtil.getCanonicalPath(node) + "' does not exist");
        }
        return modelItem.getValue();
    }

    public void setNodeValue(Node node, String value) throws XFormsException {
        if (node != null) {
            ModelItem modelItem = this.getModelItem(node);
            if (!modelItem.isReadonly()) {
                modelItem.setValue(value);
                this.model.addChanged((Node)modelItem.getNode());
            } else {
                this.getLogger().warn((Object)(this + " set node value: attempt to set readonly value"));
            }
        }
    }

    public ModelItem getModelItem(Node node) {
        if (node == null) {
            return null;
        }
        ModelItem item = (ModelItem)node.getUserData("");
        if (item == null) {
            item = Instance.createModelItem(node);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(this + " get model item: created item for path " + BindingResolver.getCanonicalPath(node)));
            }
        }
        return item;
    }

    public void setNode(Node parentNode, Element node) throws XFormsException {
        ModelItem item;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " set node value: " + BindingResolver.getCanonicalPath(parentNode) + "=" + node));
        }
        if ((item = this.getModelItem(parentNode)) == null) {
            throw new XFormsException("model item for path '" + BindingResolver.getCanonicalPath(parentNode) + "' does not exist");
        }
        if (!item.isReadonly()) {
            Node imported = this.instanceDocument.importNode(node, true);
            ((Element)item.getNode()).appendChild(imported);
            this.model.addChanged((Node)item.getNode());
        } else {
            this.getLogger().warn((Object)(this + " set node value: attempt to set readonly value"));
        }
    }

    private boolean existsNode(String path) throws XFormsException {
        return this.getContextSize(path) > 0;
    }

    private int getContextSize(String path) throws XFormsException {
        String cnt = XPathCache.getInstance().evaluateAsString(this.getInstanceNodeset(), 1, "count(" + path + ")", this.getPrefixMapping(), this.xpathFunctionContext);
        return Integer.parseInt(cnt);
    }

    public void createNode(List nodeset, int position, String qname) throws XFormsException {
        if (nodeset.size() < position) {
            return;
        }
        Node parentNode = (Node)((DOMNodeWrapper)nodeset.get(position - 1)).getUnderlyingNode();
        try {
            parentNode.appendChild(this.createElement(qname));
        }
        catch (DOMException e) {
            throw new XFormsBindingException(e.getMessage(), this.target, null);
        }
    }

    public Node insertNode(Node parentNode, Node originNode, Node beforeNode) throws XFormsException {
        String canonicalPath;
        Node insertedNode;
        ModelItem miOrigin = this.getModelItem(originNode);
        if (originNode.getNodeType() == 2) {
            insertedNode = this.instanceDocument.importNode(originNode, true);
            ((Element)parentNode).setAttributeNode((Attr)insertedNode);
        } else {
            insertedNode = parentNode.insertBefore(this.instanceDocument.importNode(originNode, true), beforeNode);
        }
        String canonPath = DOMUtil.getCanonicalPath(insertedNode);
        ModelItem insertedModelItem = this.getModelItem(insertedNode);
        insertedModelItem.getDeclarationView().setDatatype(miOrigin.getDeclarationView().getDatatype());
        insertedModelItem.getDeclarationView().setConstraints(miOrigin.getDeclarationView().getConstraints());
        if (beforeNode != null || originNode.getNodeType() == 2) {
            canonicalPath = BindingResolver.getCanonicalPath(insertedNode);
        } else {
            Node lastChild = ((DocumentTraversal)((Object)this.instanceDocument)).createTreeWalker(parentNode, -1, null, false).lastChild();
            canonicalPath = BindingResolver.getCanonicalPath(lastChild);
        }
        String[] canonicalParts = XPathUtil.getNodesetAndPredicates(canonicalPath);
        if (originNode.hasChildNodes()) {
            this.setDatatypeOnChilds(originNode, insertedNode);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeset", canonicalParts[0]);
        map.put("position", canonicalParts.length > 1 ? canonicalParts[1] : "1");
        map.put("canonPath", canonPath);
        this.container.dispatch(this.target, "betterform-node-inserted", map);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " insert node: instance data after manipulation" + this.toString(this.instanceDocument)));
        }
        return insertedNode;
    }

    private void setDatatypeOnChilds(Node originNode, Node insertedNode) {
        NodeList originChilds = originNode.getChildNodes();
        NodeList insertedChilds = insertedNode.getChildNodes();
        if (insertedChilds.getLength() == originChilds.getLength()) {
            for (int i = 0; i < originChilds.getLength(); ++i) {
                Node originChild = originChilds.item(i);
                Node insertedChild = insertedChilds.item(i);
                ModelItem modelItemOrigin = this.getModelItem(originChild);
                ModelItem modelItemInserted = this.getModelItem(insertedChild);
                modelItemInserted.getDeclarationView().setDatatype(modelItemOrigin.getDeclarationView().getDatatype());
                if (!originChild.hasChildNodes()) continue;
                this.setDatatypeOnChilds(originChild, insertedChild);
            }
        } else {
            LOGGER.debug((Object)(this + " inserted node has fewer child than origin."));
        }
    }

    private boolean isReadonly(Node n) {
        if (n.getNodeType() == 9) {
            return false;
        }
        if (this.getModelItem(n).isReadonly()) {
            return true;
        }
        if (n.getNodeType() == 2) {
            return this.isReadonly(((Attr)n).getOwnerElement());
        }
        return this.isReadonly(n.getParentNode());
    }

    public boolean deleteNode(Node node, String path) throws XFormsException {
        String canonicalPath = DOMUtil.getCanonicalPath(node);
        if (node == null) {
            LOGGER.warn((Object)"Node is null - delete is terminated with no effect.");
            return false;
        }
        if (this.isReadonly(node)) {
            LOGGER.warn((Object)"Node or one of it's parents is readonly - delete is terminated with no effect.");
            return false;
        }
        if (node.getNodeName().startsWith("xmlns")) {
            LOGGER.warn((Object)"Node is Namespace declaration - delete is terminated with no effect.");
            return false;
        }
        if (node.getNodeType() != 2 && node.getParentNode().getNodeType() == 9) {
            LOGGER.warn((Object)"Node is a root Node - delete is terminated with no effect.");
            return false;
        }
        if (node.getNodeType() == 9) {
            LOGGER.warn((Object)"Node is a Document Node - delete is terminated with no effect.");
            return false;
        }
        Node canonNode = node;
        if (node.getNodeType() != 2) {
            node.getParentNode().removeChild(node);
        } else {
            Attr attr = (Attr)node;
            attr.getOwnerElement().removeAttributeNode(attr);
        }
        String[] canonicalParts = XPathUtil.getNodesetAndPredicates(path);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nodeset", canonicalParts[0]);
        map.put("position", canonicalParts[canonicalParts.length - 1]);
        map.put("canonPath", canonicalPath);
        this.container.dispatch(this.target, "betterform-node-deleted", map);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " delete node: instance data after manipulation" + this.toString(this.instanceDocument)));
        }
        return true;
    }

    public List getInstanceNodeset() {
        String baseURI = this.container.getProcessor().getBaseURI();
        return de.betterform.xml.xpath.impl.saxon.XPathUtil.getRootContext(this.instanceDocument, baseURI);
    }

    public void setInstanceDocument(Document document) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"setInstanceDocument");
            LOGGER.debug((Object)"former instance:");
            DOMUtil.prettyPrintDOM(this.instanceDocument);
            LOGGER.debug((Object)"updated instance:");
            DOMUtil.prettyPrintDOM(document);
        }
        this.instanceDocument = document;
        this.storeContainerRef();
        this.initXPathContext();
        String refreshOriginal = this.getXFormsAttribute("refreshOriginal");
        if (refreshOriginal != null && refreshOriginal.equals("true")) {
            this.initialInstance = null;
            this.storeInitialInstance();
        }
    }

    public Document getInstanceDocument() {
        return this.instanceDocument;
    }

    public Document getInitialInstance() {
        if (this.initialInstance != null) {
            Document doc = DOMUtil.newDocument(true, false);
            doc.appendChild(doc.importNode(this.initialInstance, true));
            return doc;
        }
        return null;
    }

    public boolean hasInitialInstance() {
        return this.initialInstance != null;
    }

    void storeInitialInstance() throws XFormsException {
        if (this.initialInstance == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " store initial instance"));
            }
            try {
                this.initialInstance = (Element)this.instanceDocument.getDocumentElement().cloneNode(true);
            }
            catch (Exception e) {
                throw new XFormsException("Instance '" + this.id + "' has no root element", e);
            }
            NamespaceResolver.applyNamespaces(this.element, this.initialInstance);
        }
    }

    public void reset() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " reset"));
        }
        this.instanceDocument = this.createInstanceDocument();
        this.storeContainerRef();
        this.initXPathContext();
    }

    private Node getNode(String xpath) throws XFormsException {
        NodeInfo nodeInfo = (NodeInfo)XPathCache.getInstance().evaluate(this.xPathContext, xpath).get(0);
        return (Node)((DOMNodeWrapper)nodeInfo).getUnderlyingNode();
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    public void createRootElement(String qname) {
        if (this.instanceDocument.getDocumentElement() != null) {
            return;
        }
        this.instanceDocument.appendChild(this.createElement(qname));
    }

    private Element createElement(String qname) {
        Element root;
        int separator = qname.indexOf(58);
        if (separator > -1) {
            String prefix = qname.substring(0, separator);
            String uri = NamespaceResolver.getNamespaceURI(this.element, prefix);
            root = this.instanceDocument.createElementNS(uri, qname);
        } else {
            root = this.instanceDocument.createElement(qname);
        }
        NamespaceResolver.applyNamespaces(this.element, root);
        root.setAttribute("xmlns", "");
        return root;
    }

    private Element createInitialInstance() throws XFormsException {
        Element child;
        String srcAttribute = this.getXFormsAttribute("src");
        if (srcAttribute != null) {
            String resourceUri = srcAttribute;
            return this.fetchData(srcAttribute);
        }
        String resourceUri = "#" + this.getId();
        List childs = DOMUtil.getChildElements(this.element);
        if (childs.size() > 1) {
            HashMap<String, String> contextInfo = new HashMap<String, String>();
            contextInfo.put("resource-uri", resourceUri);
            contextInfo.put("resource-error", "multiple root elements found in instance");
            this.container.dispatch(this.model.getTarget(), "xforms-link-exception", contextInfo);
        }
        if ((child = DOMUtil.getFirstChildElement(this.element)) != null) {
            return child;
        }
        String resourceAttribute = this.getXFormsAttribute("resource");
        if (resourceAttribute != null) {
            return this.fetchData(resourceAttribute);
        }
        return null;
    }

    private Element fetchData(String srcAttribute) throws XFormsLinkException {
        Object result;
        try {
            result = this.container.getConnectorFactory().createURIResolver(srcAttribute, this.element).resolve();
        }
        catch (Exception e) {
            String msg = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("resource-uri", srcAttribute);
            map.put("detailMessage", msg);
            throw new XFormsLinkException("uri resolution failed for '" + srcAttribute + "' at Instance id: '" + this.getId() + "'", e, this.model.getTarget(), map);
        }
        if (result instanceof Document) {
            return ((Document)result).getDocumentElement();
        }
        if (result instanceof Element) {
            return (Element)result;
        }
        if (result instanceof String) {
            try {
                return DOMUtil.parseString((String)result, true, false).getDocumentElement();
            }
            catch (Exception e) {
                throw new XFormsLinkException("object model not supported", this.model.getTarget(), (Object)srcAttribute);
            }
        }
        throw new XFormsLinkException("object model not supported", this.model.getTarget(), (Object)srcAttribute);
    }

    private Document createInstanceDocument() throws XFormsException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            Document document = factory.newDocumentBuilder().newDocument();
            if (this.initialInstance != null) {
                Node imported = document.importNode(this.initialInstance.cloneNode(true), true);
                document.appendChild(imported);
                if (this.getXFormsAttribute("src") == null && this.getXFormsAttribute("resource") == null) {
                    NamespaceResolver.applyNamespaces(this.element, document.getDocumentElement());
                }
            }
            return document;
        }
        catch (Exception e) {
            throw new XFormsException(e);
        }
    }

    public static ModelItem createModelItem(Node node) {
        String id = Model.generateModelItemId();
        XercesNodeImpl modelItem = node.getNodeType() == 1 ? new XercesElementImpl(id) : new XercesNodeImpl(id);
        modelItem.setNode(node);
        Node parentNode = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode();
        if (parentNode != null) {
            ModelItem parentItem = (ModelItem)parentNode.getUserData("");
            if (parentItem == null) {
                parentItem = Instance.createModelItem(parentNode);
            }
            modelItem.setParent(parentItem);
        }
        node.setUserData("", modelItem, null);
        return modelItem;
    }

    private void listModelItems(List list, Node node, boolean deep) {
        ModelItem modelItem = (ModelItem)node.getUserData("");
        if (modelItem == null) {
            modelItem = Instance.createModelItem(node);
        }
        list.add(modelItem);
        if (deep) {
            NamedNodeMap attributes = node.getAttributes();
            for (int index = 0; attributes != null && index < attributes.getLength(); ++index) {
                this.listModelItems(list, attributes.item(index), deep);
            }
            if (node.getNodeType() != 2) {
                NodeList children = node.getChildNodes();
                for (int index = 0; index < children.getLength(); ++index) {
                    this.listModelItems(list, children.item(index), deep);
                }
            }
        }
    }

    void storeContainerRef() {
        if (this.instanceDocument.getDocumentElement() != null) {
            this.instanceDocument.getDocumentElement().setUserData("container", this.model.getContainer(), null);
            this.instanceDocument.getDocumentElement().setUserData("instance", this, null);
        }
    }

    private String toString(Node node) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DOMUtil.prettyPrintDOM(node, stream);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return System.getProperty("line.separator") + stream;
    }

    public void setLazyXPathContext(List parentNodeset) {
        this.xPathContext = new BetterFormXPathContext(parentNodeset, 1, this.getPrefixMapping(), this.xpathFunctionContext);
    }
}

