/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model;

import de.betterform.connector.ConnectorFactory;
import de.betterform.xml.config.Config;
import de.betterform.xml.events.DefaultAction;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.action.UpdateHandler;
import de.betterform.xml.xforms.action.UpdateSequencer;
import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.exception.XFormsLinkException;
import de.betterform.xml.xforms.exception.XFormsVersionException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.Bind;
import de.betterform.xml.xforms.model.bind.RefreshView;
import de.betterform.xml.xforms.model.constraints.MainDependencyGraph;
import de.betterform.xml.xforms.model.constraints.SubGraph;
import de.betterform.xml.xforms.model.constraints.Validator;
import de.betterform.xml.xforms.model.constraints.Vertex;
import de.betterform.xml.xpath.XPathUtil;
import de.betterform.xml.xpath.impl.saxon.SaxonReferenceFinderImpl;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.events.Event;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.w3c.xforms.XFormsModelElement;

public class Model
extends XFormsElement
implements XFormsModelElement,
DefaultAction {
    private static Log LOGGER = LogFactory.getLog(Model.class);
    private List instances;
    private List modelBindings;
    private MainDependencyGraph mainGraph;
    private Validator validator;
    private Vector changed = new Vector();
    private List schemas;
    private boolean ready;
    private UpdateHandler updateHandler;
    private UpdateSequencer updateSequencer;
    private static int modelItemCounter = 0;
    private static XSModel defaultSchema = null;
    private List refreshedItems;

    public Model(Element element) {
        super(element);
    }

    public boolean isReady() {
        return this.ready;
    }

    public Vector getChanged() {
        return this.changed;
    }

    public Container getContainer() {
        return this.container;
    }

    public Instance getDefaultInstance() {
        if (this.instances != null && this.instances.size() > 0) {
            return (Instance)this.instances.get(0);
        }
        return null;
    }

    public Instance getInstance(String id) {
        if (this.instances == null) {
            return null;
        }
        if (id == null || "".equals(id)) {
            return this.getDefaultInstance();
        }
        for (int index = 0; index < this.instances.size(); ++index) {
            Instance instance = (Instance)this.instances.get(index);
            if (!id.equals(instance.getId())) continue;
            return instance;
        }
        return null;
    }

    public List getInstances() {
        return this.instances;
    }

    public String computeInstanceId(String path) throws XFormsException {
        if (path == null) {
            return null;
        }
        String expression = XPathUtil.getInstanceParameter(path);
        if (expression != null) {
            if (expression.equals("") || expression.equals("''")) {
                return this.getDefaultInstance().getId();
            }
            String value = XPathCache.getInstance().evaluateAsString(this.getDefaultInstance().getRootContext(), "string(" + expression + ")");
            String realId = null;
            Instance instance = this.getInstance(value);
            if (instance != null) {
                realId = instance.getId();
            }
            return realId;
        }
        Instance defaultInstance = this.getDefaultInstance();
        if (defaultInstance == null) {
            return "default";
        }
        return this.getDefaultInstance().getId();
    }

    public MainDependencyGraph getMainGraph() {
        return this.mainGraph;
    }

    @Override
    public Model getModel() {
        return this;
    }

    public Validator getValidator() {
        if (this.validator == null) {
            this.validator = new Validator();
            this.validator.setModel(this);
        }
        return this.validator;
    }

    public List getSchemas() {
        return this.schemas;
    }

    public void addChanged(Node changedNode) {
        if (this.mainGraph != null) {
            Vertex vertex;
            if (this.changed == null) {
                this.changed = new Vector();
            }
            if ((vertex = this.mainGraph.getVertex(changedNode, (short)1, null)) != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " add changed: adding calculate vertex for " + changedNode));
                }
                this.changed.add(vertex);
            }
        }
    }

    public Instance addInstance(String id) throws XFormsException {
        Element instanceNode = this.element.getOwnerDocument().createElementNS("http://www.w3.org/2002/xforms", (this.xformsPrefix != null ? this.xformsPrefix : "xf") + ":" + "instance");
        String realId = id;
        if (realId == null || realId.length() == 0) {
            realId = this.container.generateId();
        }
        instanceNode.setAttributeNS(null, "id", realId);
        instanceNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        this.element.appendChild(instanceNode);
        this.createInstanceObject(instanceNode);
        return this.getInstance(id);
    }

    public void addBindElement(Bind bind) {
        if (this.modelBindings == null) {
            this.modelBindings = new ArrayList();
        }
        this.modelBindings.add(bind);
    }

    public UpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public void setUpdateHandler(UpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    public static String generateModelItemId() {
        return String.valueOf(++modelItemCounter);
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.refreshedItems = new ArrayList();
        this.updateSequencer = new UpdateSequencer(this);
        this.initializeDefaultAction();
        this.initializeExtensionFunctions();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.instances = null;
        this.modelBindings = null;
        this.mainGraph = null;
        this.validator = null;
        this.changed = null;
        this.schemas = null;
        this.updateHandler = null;
        this.updateSequencer = null;
        this.disposeDefaultAction();
        this.element.setUserData("", null, null);
    }

    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-model-construct", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-model-construct-done", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-model-destruct", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-ready", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-refresh", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-revalidate", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-recalculate", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-rebuild", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-reset", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-link-exception", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-link-error", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-compute-exception", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-version-exception", this);
    }

    protected void initializeExtensionFunctions() throws XFormsComputeException {
        String functions = this.getXFormsAttribute("functions");
        if (functions != null && !functions.equals("")) {
            StringTokenizer tokenizer = new StringTokenizer(functions);
            while (tokenizer.hasMoreTokens()) {
                StructuredQName functionName;
                SymbolicName sn;
                FunctionLibraryList functionLibrary;
                String localName;
                String qname = tokenizer.nextToken();
                String prefix = "";
                if (qname.indexOf(":") == -1) {
                    localName = qname;
                } else {
                    prefix = qname.substring(0, qname.indexOf(":"));
                    localName = qname.substring(qname.indexOf(":") + 1);
                    String[] stringArray = new String[]{""};
                }
                String namespaceURI = NamespaceResolver.getNamespaceURI(this.element, prefix);
                if (namespaceURI == null) {
                    namespaceURI = "";
                }
                if ((functionLibrary = XPathCache.getFgXFormsFunctionLibrary()).isAvailable(sn = new SymbolicName(155, functionName = new StructuredQName(prefix, namespaceURI, localName), -1))) continue;
                throw new XFormsComputeException("Function '" + localName + "' cannot be found in Namespace: '" + namespaceURI + "'", this.target, null);
            }
        }
    }

    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-model-construct", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-model-construct-done", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-model-destruct", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-ready", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-refresh", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-revalidate", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-recalculate", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-rebuild", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-reset", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-link-exception", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-link-error", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-compute-exception", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-version-exception", this);
    }

    @Override
    public Document getInstanceDocument(String instanceID) throws DOMException {
        Instance instance = this.getInstance(instanceID);
        if (instance == null) {
            throw new DOMException(8, instanceID);
        }
        return instance.getInstanceDocument();
    }

    @Override
    public void rebuild() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " #################### REBUILD ####################"));
            this.getLogger().debug((Object)this);
        }
        try {
            if (this.updateSequencer.sequence("rebuild")) {
                return;
            }
            if (this.modelBindings != null && this.modelBindings.size() > 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " rebuild: creating main dependency graph for " + this.modelBindings.size() + " bind(s)"));
                }
                this.mainGraph = new MainDependencyGraph();
                for (int index = 0; index < this.modelBindings.size(); ++index) {
                    Bind bind = (Bind)this.modelBindings.get(index);
                    bind.updateXPathContext();
                    this.mainGraph.buildBindGraph(bind, this);
                }
                this.changed = (Vector)this.mainGraph.getVertices().clone();
            }
            this.updateSequencer.perform();
        }
        catch (Exception e) {
            this.updateSequencer.reset();
            this.container.handleEventException(e);
        }
    }

    @Override
    public void recalculate() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)" #################### RECALCULATE ####################");
            this.getLogger().debug((Object)this);
        }
        try {
            if (this.updateSequencer.sequence("recalculate")) {
                return;
            }
            if (this.changed != null && this.changed.size() > 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " recalculate: creating sub dependency graph for " + this.changed.size() + " node(s)"));
                }
                SubGraph subGraph = new SubGraph();
                subGraph.constructSubDependencyGraph(this.changed);
                subGraph.recalculate();
                this.changed.clear();
            }
            this.updateSequencer.perform();
        }
        catch (Exception e) {
            this.updateSequencer.reset();
            this.container.handleEventException(e);
        }
    }

    @Override
    public void revalidate() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)" #################### REVALIDATE ####################");
            this.getLogger().debug((Object)this);
        }
        try {
            if (this.updateSequencer.sequence("revalidate")) {
                return;
            }
            if (this.instances != null && this.instances.size() > 0) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)(this + " revalidate: revalidating " + this.instances.size() + " instance(s)"));
                }
                for (int index = 0; index < this.instances.size(); ++index) {
                    this.getValidator().validate((Instance)this.instances.get(index));
                }
            }
            this.updateSequencer.perform();
        }
        catch (Exception e) {
            this.updateSequencer.reset();
            this.container.handleEventException(e);
        }
    }

    @Override
    public void refresh() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(" #################### START REFRESH Model " + this.id + " ####################"));
            this.getLogger().debug((Object)this);
        }
        try {
            if (this.updateSequencer.sequence("refresh")) {
                return;
            }
            Initializer.updateUIElements(this.container.getDocument().getDocumentElement(), this);
            if (this.instances != null) {
                for (int index = 0; index < this.instances.size(); ++index) {
                    Instance instance = (Instance)this.instances.get(index);
                    Iterator iterator = instance.iterateModelItems();
                    while (iterator.hasNext()) {
                        ModelItem modelItem = (ModelItem)iterator.next();
                        modelItem.getStateChangeView().reset();
                    }
                }
            }
            for (int index = 0; index < this.refreshedItems.size(); ++index) {
                RefreshView refreshView = (RefreshView)this.refreshedItems.get(index);
                refreshView.reset();
            }
            this.refreshedItems.clear();
            this.updateSequencer.perform();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " #################### END REFRESH Model " + this.id + " ####################"));
            }
        }
        catch (Exception e) {
            this.updateSequencer.reset();
            this.container.handleEventException(e);
        }
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    @Override
    public void performDefault(Event event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("\n\n>>>>>>>>>>>>>>>>>>>>>>>>> " + event.getType().toUpperCase() + " <<<<<<<<<<<<<<<<<<<<<<<<<\n\n"));
        }
        try {
            if (event.getType().equals("xforms-model-construct")) {
                this.modelConstruct();
                return;
            }
            if (event.getType().equals("xforms-model-construct-done")) {
                this.modelConstructDone();
                return;
            }
            if (event.getType().equals("xforms-model-destruct")) {
                this.dispose();
                return;
            }
            if (event.getType().equals("xforms-ready")) {
                this.ready();
                return;
            }
            if (event.getType().equals("xforms-refresh")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.refresh();
                return;
            }
            if (event.getType().equals("xforms-revalidate")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.revalidate();
                return;
            }
            if (event.getType().equals("xforms-recalculate")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.recalculate();
                return;
            }
            if (event.getType().equals("xforms-rebuild")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.rebuild();
                return;
            }
            if (event.getType().equals("xforms-reset")) {
                if (this.isCancelled(event)) {
                    this.getLogger().debug((Object)(this + event.getType() + " cancelled"));
                    return;
                }
                this.reset();
                return;
            }
            if (event.getType().equals("xforms-binding-exception")) {
                this.getLogger().error((Object)(this + " binding exception: " + ((XMLEvent)event).getContextInfo()));
                return;
            }
            if (event.getType().equals("xforms-link-exception")) {
                this.getLogger().error((Object)(this + " link exception: " + ((XMLEvent)event).getContextInfo()));
            }
            if (event.getType().equals("xforms-link-error")) {
                this.getLogger().warn((Object)(this + " link error: " + ((XMLEvent)event).getContextInfo()));
                return;
            }
            if (event.getType().equals("xforms-compute-exception")) {
                this.getLogger().error((Object)(this + " compute exception: " + ((XMLEvent)event).getContextInfo()));
                return;
            }
            if (event.getType().equals("xforms-version-exception")) {
                this.getLogger().error((Object)(this + " version exception: " + ((XMLEvent)event).getContextInfo()));
                this.container.shutdown();
                throw new XFormsVersionException("version exception: " + ((XMLEvent)event).getContextInfo().get("error-information"), event.getTarget(), ((XMLEvent)event).getContextInfo());
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.stopPropagation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modelConstruct() throws XFormsException {
        this.schemas = new ArrayList();
        this.loadDefaultSchema(this.schemas);
        this.loadLinkedSchemas(this.schemas);
        this.loadInlineSchemas(this.schemas);
        Class<Model> clazz = Model.class;
        synchronized (Model.class) {
            this.getValidator().setDatatypes(this.getNamedDatatypes(this.schemas));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.instances = new ArrayList();
            List<Element> instanceElements = this.getAllInstanceElements();
            int count = instanceElements.size();
            if (count > 0) {
                for (int index = 0; index < count; ++index) {
                    Element xformsInstance = instanceElements.get(index);
                    this.createInstanceObject(xformsInstance);
                }
            }
            Initializer.initializeBindElements(this, this.element, new SaxonReferenceFinderImpl());
            Initializer.initializeActionElements(this, this.element);
            Initializer.initializeSubmissionElements(this, this.element);
            this.rebuild();
            this.recalculate();
            this.revalidate();
            return;
        }
    }

    private List<Element> getAllInstanceElements() {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Node it = this.getElement().getFirstChild(); it != null; it = it.getNextSibling()) {
            if (it.getNodeType() != 1) continue;
            Element el = (Element)it;
            if (!"http://www.w3.org/2002/xforms".equals(it.getNamespaceURI()) || !"instance".equals(el.getLocalName())) continue;
            result.add(el);
        }
        return result;
    }

    private void createInstanceObject(Element xformsInstance) throws XFormsException {
        Instance instance = (Instance)this.container.getElementFactory().createXFormsElement(xformsInstance, this);
        instance.init();
        this.instances.add(instance);
        String debug = Config.getInstance().getProperty("betterform.debug-allowed");
        if (debug != null && debug.equals("true")) {
            HashMap<String, String> contextInfo = new HashMap<String, String>(1);
            contextInfo.put("modelId", XFormsElement.getXFormsAttribute((Element)xformsInstance.getParentNode(), "id"));
            contextInfo.put("instanceId", XFormsElement.getXFormsAttribute(xformsInstance, "id"));
            this.container.dispatch(this.target, "betterform-instance-created", contextInfo);
        }
    }

    private void modelConstructDone() throws XFormsException {
        if (this.getContainer().isModelConstructDone()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " model construct done: already performed"));
            }
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " model construct done: starting ui initialization"));
            }
            Initializer.initializeUIElements(this.container.getDocument().getDocumentElement());
            Instance inst = this.getDefaultInstance();
            if (inst != null && !inst.hasInitialInstance()) {
                inst.storeContainerRef();
            }
        }
    }

    private void ready() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " ready"));
        }
        if (this.instances != null) {
            for (int index = 0; index < this.instances.size(); ++index) {
                Instance instance = (Instance)this.instances.get(index);
                instance.storeInitialInstance();
                try {
                    Iterator iterator = instance.iterateModelItems();
                    while (iterator.hasNext()) {
                        ModelItem modelItem = (ModelItem)iterator.next();
                        modelItem.getStateChangeView().reset();
                        modelItem.getRefreshView().reset();
                    }
                    continue;
                }
                catch (XFormsException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        this.ready = true;
    }

    private void reset() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " reset"));
        }
        if (this.instances != null && this.instances.size() > 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " reset: resetting " + this.instances.size() + " instance(s)"));
            }
            for (int index = 0; index < this.instances.size(); ++index) {
                Instance instance = (Instance)this.instances.get(index);
                instance.reset();
            }
        }
        this.container.dispatch(this.target, "xforms-rebuild", null);
        this.container.dispatch(this.target, "xforms-recalculate", null);
        this.container.dispatch(this.target, "xforms-revalidate", null);
        this.container.dispatch(this.target, "xforms-refresh", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultSchema(List list) throws XFormsException {
        try {
            Class<Model> clazz = Model.class;
            synchronized (Model.class) {
                if (defaultSchema == null) {
                    InputStream stream = Config.class.getResourceAsStream(Config.getInstance().getProperty("xforms.schema"));
                    defaultSchema = this.loadSchema(stream);
                }
                if (defaultSchema == null) {
                    throw new NullPointerException("resource not found");
                }
                list.add(defaultSchema);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            throw new XFormsLinkException("could not load default schema", e, this.target, null);
        }
        {
            return;
        }
    }

    private void loadLinkedSchemas(List list) throws XFormsException {
        String schemaURI = null;
        try {
            String schemaAttribute = this.getXFormsAttribute("schema");
            if (schemaAttribute != null) {
                StringTokenizer tokenizer = new StringTokenizer(schemaAttribute, " ");
                XSModel schema = null;
                while (tokenizer.hasMoreTokens()) {
                    schemaURI = tokenizer.nextToken();
                    if (schemaURI.startsWith("#")) {
                        String id = schemaURI.substring(1);
                        Element element = this.container.getElementById(id);
                        schema = this.loadSchema(element);
                    } else {
                        schema = this.loadSchema(schemaURI);
                    }
                    if (schema == null) {
                        throw new NullPointerException("resource not found");
                    }
                    list.add(schema);
                }
            }
        }
        catch (Exception e) {
            throw new XFormsLinkException("could not load linked schema", e, this.target, schemaURI);
        }
    }

    private void loadInlineSchemas(List list) throws XFormsException {
        String schemaId = null;
        try {
            NodeList children = this.element.getChildNodes();
            for (int index = 0; index < children.getLength(); ++index) {
                Node child = children.item(index);
                if (1 != child.getNodeType() || !"http://www.w3.org/2001/XMLSchema".equals(child.getNamespaceURI())) continue;
                Element element = (Element)child;
                schemaId = element.hasAttributeNS(null, "id") ? element.getAttributeNS(null, "id") : element.getNodeName();
                XSModel schema = this.loadSchema(element);
                if (schema == null) {
                    throw new NullPointerException("resource not found");
                }
                list.add(schema);
            }
        }
        catch (Exception e) {
            throw new XFormsLinkException("could not load inline schema", e, this.target, schemaId);
        }
    }

    public Map getNamedDatatypes(List schemas) {
        HashMap<String, XSTypeDefinition> datatypes = new HashMap<String, XSTypeDefinition>();
        for (XSModel schema : schemas) {
            XSNamedMap definitions = schema.getComponents((short)3);
            for (int index = 0; index < definitions.getLength(); ++index) {
                XSTypeDefinition type = (XSTypeDefinition)definitions.item(index);
                if (type.getTypeCategory() != 16 || type.getAnonymous() || !this.getValidator().isSupported(type.getName())) continue;
                String name = type.getName();
                int separator = name.indexOf(58);
                String localName = separator > -1 ? name.substring(separator + 1) : name;
                String namespaceURI = type.getNamespace();
                String expandedName = NamespaceResolver.expand(namespaceURI, localName);
                if ("http://www.w3.org/2002/xforms".equals(namespaceURI) || "http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                    datatypes.put(localName, type);
                }
                datatypes.put(expandedName, type);
            }
        }
        return datatypes;
    }

    public String getTargetNamespace(XSModel xsModel) {
        String namespace = xsModel.getComponents((short)3).item(0).getNamespace();
        return namespace;
    }

    public void addRefreshItem(RefreshView changed) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("add refreshView " + changed.toString()));
        }
        this.refreshedItems.add(changed);
    }

    private XSModel loadSchema(String uri) throws XFormsException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        ConnectorFactory connectorFactory = this.container.getConnectorFactory();
        URI absoluteURI = connectorFactory.getAbsoluteURI(uri, this.element);
        return this.getSchemaLoader().loadURI(absoluteURI.toString());
    }

    private XSModel loadSchema(InputStream stream) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        DOMInputImpl input = new DOMInputImpl();
        input.setByteStream(stream);
        return this.getSchemaLoader().load((LSInput)input);
    }

    private XSModel loadSchema(Element element) throws TransformerException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Element copy = (Element)element.cloneNode(true);
        NamespaceResolver.applyNamespaces(element, copy);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.transform(new DOMSource(copy), new StreamResult(stream));
        byte[] array = stream.toByteArray();
        return this.loadSchema(new ByteArrayInputStream(array));
    }

    private XSLoader getSchemaLoader() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementation implementation = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        XSLoader loader = implementation.createXSLoader(null);
        DOMConfiguration cfg = loader.getConfig();
        cfg.setParameter("resource-resolver", new LSResourceResolver(){

            @Override
            public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
                LSInput input = new LSInput(){
                    String systemId;
                    String publicId;
                    String baseURI;

                    @Override
                    public void setSystemId(String systemId) {
                        this.systemId = systemId;
                    }

                    @Override
                    public void setStringData(String s) {
                    }

                    @Override
                    public void setPublicId(String publicId) {
                        this.publicId = publicId;
                    }

                    @Override
                    public void setEncoding(String s) {
                    }

                    @Override
                    public void setCharacterStream(Reader reader) {
                    }

                    @Override
                    public void setCertifiedText(boolean flag) {
                    }

                    @Override
                    public void setByteStream(InputStream inputstream) {
                    }

                    @Override
                    public void setBaseURI(String baseURI) {
                        if (baseURI == null || "".equals(baseURI)) {
                            baseURI = Model.this.getContainer().getProcessor().getBaseURI();
                        }
                        this.baseURI = baseURI;
                    }

                    @Override
                    public String getSystemId() {
                        return this.systemId;
                    }

                    @Override
                    public String getStringData() {
                        return null;
                    }

                    @Override
                    public String getPublicId() {
                        return this.publicId;
                    }

                    @Override
                    public String getEncoding() {
                        return null;
                    }

                    @Override
                    public Reader getCharacterStream() {
                        return null;
                    }

                    @Override
                    public boolean getCertifiedText() {
                        return false;
                    }

                    @Override
                    public InputStream getByteStream() {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace((Object)("Schema resource\n\t\t publicId '" + this.publicId + "'\n\t\t systemId '" + this.systemId + "' requested"));
                        }
                        try {
                            String pathToSchema = null;
                            if ("http://www.w3.org/MarkUp/SCHEMA/xml-events-attribs-1.xsd".equals(this.systemId)) {
                                pathToSchema = "schema/xml-events-attribs-1.xsd";
                            } else if ("http://www.w3.org/2001/XMLSchema.xsd".equals(this.systemId)) {
                                pathToSchema = "schema/XMLSchema.xsd";
                            } else if ("-//W3C//DTD XMLSCHEMA 200102//EN".equals(this.publicId)) {
                                pathToSchema = "schema/XMLSchema.dtd";
                            } else if ("datatypes".equals(this.publicId)) {
                                pathToSchema = "schema/datatypes.dtd";
                            } else if ("http://www.w3.org/2001/xml.xsd".equals(this.systemId)) {
                                pathToSchema = "schema/xml.xsd";
                            }
                            if (pathToSchema != null) {
                                if (LOGGER.isTraceEnabled()) {
                                    LOGGER.trace((Object)("loading Schema '" + pathToSchema + "'\n\n"));
                                }
                                return Thread.currentThread().getContextClassLoader().getResourceAsStream(pathToSchema);
                            }
                            if (this.systemId != null && !"".equals(this.systemId)) {
                                URI schemaURI = new URI(this.baseURI);
                                schemaURI = schemaURI.resolve(this.systemId);
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug((Object)("loading schema resource '" + schemaURI.toString() + "'\n\n"));
                                }
                                return ConnectorFactory.getFactory().getHTTPResourceAsStream(schemaURI);
                            }
                            LOGGER.error((Object)("resource not known '" + this.systemId + "'\n\n"));
                            return null;
                        }
                        catch (XFormsException e) {
                            e.printStackTrace();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }

                    @Override
                    public String getBaseURI() {
                        return this.baseURI;
                    }
                };
                input.setSystemId(systemId);
                input.setBaseURI(baseURI);
                input.setPublicId(publicId);
                return input;
            }
        });
        return loader;
    }
}

