/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.bind;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.model.bind.Binding;
import de.betterform.xml.xpath.XPathUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BindingResolver {
    public static String getExpressionPath(XFormsElement xFormsElement, String repeatEntryId) {
        String expressionPath;
        Binding bindingElement;
        Container container = xFormsElement.getContainerObject();
        boolean modelBinding = BindingResolver.hasModelBinding(xFormsElement.getElement());
        if (modelBinding) {
            String bindId = ((Binding)((Object)xFormsElement)).getBindingId();
            bindingElement = (Binding)((Object)container.lookup(bindId));
        } else {
            bindingElement = (Binding)((Object)xFormsElement);
        }
        if (repeatEntryId != null) {
            Binding repeatItem = (Binding)((Object)container.lookup(repeatEntryId));
            String relativeId = repeatItem.getBindingId();
            String relativePath = container.getBindingResolver().resolve(bindingElement, relativeId);
            expressionPath = XPathUtil.isAbsolutePath(relativePath) ? relativePath : (relativePath.length() == 0 ? repeatItem.getLocationPath() : repeatItem.getLocationPath() + "/" + relativePath);
        } else {
            expressionPath = container.getBindingResolver().resolve(bindingElement);
        }
        return expressionPath;
    }

    public static String getCanonicalPath(Node node) {
        String canonPath = node.getNodeName();
        if (node.getNodeType() == 2) {
            canonPath = "@" + canonPath;
        } else if (node.getNodeType() == 1) {
            int position = DOMUtil.getCurrentNodesetPosition(node);
            canonPath = node.getParentNode() != null && node.getParentNode().getNodeType() != 9 ? canonPath + "[" + position + "]" : "*[1]";
        }
        Node parent = null;
        if (node.getNodeType() == 1 || node.getNodeType() == 3) {
            parent = node.getParentNode();
        } else if (node.getNodeType() == 2) {
            parent = ((Attr)node).getOwnerElement();
        }
        canonPath = parent == null || parent.getNodeType() == 9 || parent.getNodeType() == 11 ? "/" + canonPath : BindingResolver.getCanonicalPath(parent) + "/" + canonPath;
        return canonPath;
    }

    public static boolean hasModelBinding(Element element) {
        return element.hasAttributeNS("http://www.w3.org/2002/xforms", "bind") || element.hasAttributeNS(null, "bind") || element.hasAttributeNS("http://www.w3.org/2002/xforms", "repeat-bind");
    }

    public static boolean hasModelBindingExpression(Element element) {
        return "http://www.w3.org/2002/xforms".equals(element.getNamespaceURI()) && element.getLocalName().equals("bind") && (element.hasAttributeNS("http://www.w3.org/2002/xforms", "nodeset") || element.hasAttributeNS(null, "nodeset"));
    }

    private static boolean hasNodesetBindingExpression(Element element) {
        return element.hasAttributeNS("http://www.w3.org/2002/xforms", "nodeset") || element.hasAttributeNS(null, "nodeset") || element.hasAttributeNS("http://www.w3.org/2002/xforms", "repeat-ref") || element.hasAttributeNS("http://www.w3.org/2002/xforms", "repeat-nodeset");
    }

    private static boolean hasSingleNodeBindingExpression(Element element) {
        return element.hasAttributeNS("http://www.w3.org/2002/xforms", "ref") || element.hasAttributeNS(null, "ref");
    }

    public static boolean hasUIBinding(Element element) {
        return !BindingResolver.hasModelBinding(element) && (BindingResolver.hasSingleNodeBindingExpression(element) || BindingResolver.hasNodesetBindingExpression(element));
    }

    public String resolve(Binding binding) {
        return this.resolve(binding, null);
    }

    private String resolve(Binding binding, String relativeId) {
        String expression = binding.getContextExpression();
        String bindingExpression = binding.getBindingExpression();
        if (bindingExpression != null) {
            expression = expression == null || expression.length() == 0 || XPathUtil.isDotReference(expression) || XPathUtil.isAbsolutePath(bindingExpression) ? bindingExpression : expression + "/" + bindingExpression;
        }
        if (expression == null || expression.length() == 0 || XPathUtil.isDotReference(expression)) {
            Binding enclosing = binding.getEnclosingBinding();
            if (enclosing == null) {
                return "/*[1]";
            }
            if (enclosing.getBindingId().equals(relativeId)) {
                return "";
            }
            return this.resolve(enclosing, relativeId);
        }
        if (XPathUtil.isAbsolutePath(expression = XPathUtil.stripSelfReference(expression))) {
            return expression;
        }
        Binding enclosing = binding.getEnclosingBinding();
        if (enclosing != null) {
            if (enclosing.getBindingId().equals(relativeId)) {
                return expression;
            }
            String parent = this.resolve(enclosing, relativeId);
            if (parent.length() == 0) {
                return expression;
            }
            return parent + "/" + expression;
        }
        return "/*[1]/" + expression;
    }
}

