/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.bind.impl;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.Constraint;
import de.betterform.xml.xforms.model.bind.RefreshView;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class RefreshViewImpl
implements RefreshView {
    private static final Log LOGGER = LogFactory.getLog(RefreshView.class);
    private ModelItem modelItem;
    private boolean valueChangedMarker;
    private boolean validMarker;
    private boolean invalidMarker;
    private boolean readwriteMarker;
    private boolean readonlyMarker;
    private boolean optionalMarker;
    private boolean requiredMarker;
    private boolean enabledMarker;
    private boolean disabledMarker;
    private List invalids;

    public RefreshViewImpl(ModelItem modelItem) {
        this.modelItem = modelItem;
        this.invalids = new ArrayList(5);
    }

    @Override
    public void setValueChangedMarker() {
        this.valueChangedMarker = true;
        Model model = this.modelItem.getModel();
        if (model != null) {
            this.modelItem.getModel().addRefreshItem(this);
        }
    }

    @Override
    public void setReadonlyMarker() {
        this.readwriteMarker = false;
        this.readonlyMarker = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("readonly MIP marked for dispatching for " + DOMUtil.getCanonicalPath((Node)this.modelItem.getNode())));
        }
    }

    @Override
    public void setReadWriteMarker() {
        this.readonlyMarker = false;
        this.readwriteMarker = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("readwrite MIP marked for dispatching for " + DOMUtil.getCanonicalPath((Node)this.modelItem.getNode())));
        }
    }

    @Override
    public void setEnabledMarker() {
        this.disabledMarker = false;
        this.enabledMarker = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("enabled MIP marked for dispatching for " + DOMUtil.getCanonicalPath((Node)this.modelItem.getNode())));
        }
    }

    @Override
    public void setDisabledMarker() {
        this.enabledMarker = false;
        this.disabledMarker = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("disabled MIP marked for dispatching for " + DOMUtil.getCanonicalPath((Node)this.modelItem.getNode())));
        }
    }

    @Override
    public void setOptionalMarker() {
        this.requiredMarker = false;
        this.optionalMarker = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("optional MIP marked for dispatching for " + DOMUtil.getCanonicalPath((Node)this.modelItem.getNode())));
        }
    }

    @Override
    public void setRequiredMarker() {
        this.optionalMarker = false;
        this.requiredMarker = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("required MIP marked for dispatching for " + DOMUtil.getCanonicalPath((Node)this.modelItem.getNode())));
        }
    }

    @Override
    public void setValidMarker() {
        this.invalidMarker = false;
        this.validMarker = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("valid MIP marked for dispatching for " + DOMUtil.getCanonicalPath((Node)this.modelItem.getNode())));
        }
    }

    @Override
    public void setInvalidMarker() {
        this.validMarker = false;
        this.invalidMarker = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("invalid MIP marked for dispatching for " + DOMUtil.getCanonicalPath((Node)this.modelItem.getNode())));
        }
    }

    @Override
    public List<Constraint> getInvalids() {
        return this.invalids;
    }

    @Override
    public void setInvalids(List<Constraint> invalids) {
        this.invalids = invalids;
    }

    @Override
    public void reset() {
        this.valueChangedMarker = false;
        this.invalidMarker = false;
        this.validMarker = false;
        this.readwriteMarker = false;
        this.readonlyMarker = false;
        this.optionalMarker = false;
        this.requiredMarker = false;
        this.enabledMarker = false;
        this.disabledMarker = false;
    }

    @Override
    public boolean isValueChangedMarked() {
        return this.valueChangedMarker;
    }

    @Override
    public boolean isValidMarked() {
        return this.validMarker;
    }

    @Override
    public boolean isInvalidMarked() {
        return this.invalidMarker;
    }

    @Override
    public boolean isReadonlyMarked() {
        if (this.inheritsReadWriteMip() && this.modelItem.getParent() != null) {
            if (this.modelItem.getParent().getRefreshView().isReadonlyMarked()) {
                this.readonlyMarker = true;
                this.addParentRefreshViewToModel();
            } else {
                this.readonlyMarker = false;
            }
            return this.readonlyMarker;
        }
        return this.readonlyMarker;
    }

    @Override
    public boolean isReadwriteMarked() {
        if (this.inheritsReadWriteMip() && this.modelItem.getParent() != null) {
            if (this.modelItem.getParent().getRefreshView().isReadwriteMarked()) {
                this.readwriteMarker = true;
                this.addParentRefreshViewToModel();
            } else {
                this.readwriteMarker = false;
            }
            return this.readwriteMarker;
        }
        return this.readwriteMarker;
    }

    @Override
    public boolean isRequiredMarked() {
        return this.requiredMarker;
    }

    @Override
    public boolean isOptionalMarked() {
        return this.optionalMarker;
    }

    private boolean inheritsReadWriteMip() {
        return !this.readwriteMarker && !this.readonlyMarker;
    }

    private boolean inheritsRelevantMip() {
        return !this.enabledMarker && !this.disabledMarker;
    }

    @Override
    public boolean isEnabledMarked() {
        if (this.inheritsRelevantMip() && this.modelItem.getParent() != null) {
            if (this.modelItem.getParent().getRefreshView().isEnabledMarked()) {
                this.enabledMarker = true;
                this.addParentRefreshViewToModel();
            } else {
                this.enabledMarker = false;
            }
            return this.enabledMarker;
        }
        return this.enabledMarker;
    }

    @Override
    public boolean isDisabledMarked() {
        if (this.inheritsRelevantMip() && this.modelItem.getParent() != null) {
            if (this.modelItem.getParent().getRefreshView().isDisabledMarked()) {
                this.disabledMarker = true;
                this.addParentRefreshViewToModel();
            } else {
                this.disabledMarker = false;
            }
            return this.disabledMarker;
        }
        return this.disabledMarker;
    }

    public String toString() {
        return this.modelItem.toString();
    }

    private void addParentRefreshViewToModel() {
        Model model = this.modelItem.getModel();
        if (model != null) {
            model.addRefreshItem(this.modelItem.getParent().getRefreshView());
        }
    }
}

