/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.constraints;

import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.constraints.Vertex;
import de.betterform.xml.xpath.impl.saxon.BetterFormXPathContext;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class CalculateVertex
extends Vertex {
    private static Log LOGGER = LogFactory.getLog(CalculateVertex.class);

    public CalculateVertex(BetterFormXPathContext relativeContext, Node instanceNode, String xpathExpression) {
        super(relativeContext, instanceNode, xpathExpression);
    }

    @Override
    public short getVertexType() {
        return 1;
    }

    @Override
    public void compute() throws XFormsComputeException {
        if (this.xpathExpression != null) {
            ModelItem modelItem = (ModelItem)this.instanceNode.getUserData("");
            try {
                String result = XPathCache.getInstance().evaluateAsString(this.relativeContext, "string(" + this.xpathExpression + ")");
                modelItem.setValue(result);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("evaluated expression '" + this.xpathExpression + "' to '" + result + "'"));
                }
            }
            catch (XFormsException xfe) {
                throw new XFormsComputeException(xfe.getMessage(), (Exception)xfe.getCause(), modelItem.getModel().getTarget(), xfe.getMessage());
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.xpathExpression == null) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof CalculateVertex)) {
                return false;
            }
            CalculateVertex v = (CalculateVertex)object;
            return this.instanceNode.equals(v.instanceNode) && v.xpathExpression == null;
        }
        return super.equals(object);
    }

    @Override
    public String toString() {
        if (this.xpathExpression == null) {
            return super.toString() + " - value(" + (this.instanceNode.getNodeType() == 2 ? "@" : "") + this.instanceNode.getNodeName() + ")";
        }
        return super.toString() + " - calculate(" + this.xpathExpression + ")";
    }
}

