/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.constraints;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.Bind;
import de.betterform.xml.xforms.model.constraints.DependencyGraph;
import de.betterform.xml.xforms.model.constraints.Vertex;
import de.betterform.xml.xpath.impl.saxon.BetterFormXPathContext;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class MainDependencyGraph
extends DependencyGraph {
    private static Log LOGGER = LogFactory.getLog(MainDependencyGraph.class);

    public Vector getVertices() {
        return this.vertices;
    }

    private void addReferredNodesToGraph(BetterFormXPathContext relativeContext, Node instanceNode, String expression, short property, Set references) throws XFormsException {
        this.addReferredNodesToGraph(relativeContext, instanceNode, expression, property, references, null);
    }

    private void addReferredNodesToGraph(BetterFormXPathContext relativeContext, Node instanceNode, String expression, short property, Set references, String customMIP) throws XFormsException {
        Vertex vertex = this.addVertex(relativeContext, instanceNode, expression, property, customMIP);
        boolean hadVertex = vertex.wasAlreadyInGraph;
        vertex.wasAlreadyInGraph = false;
        String xpath = vertex.getXPathExpression();
        vertex.setXpathExpression(expression);
        if (xpath == null || xpath.length() == 0) {
            if (!hadVertex) {
                this.removeVertex(vertex);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("addReferredNodesToGraph: ignoring vertex " + vertex + " without xpath"));
            }
            return;
        }
        Vector refns = this.getXPathRefNodes(relativeContext, xpath, references);
        if (refns == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("addReferredNodesToGraph: ignoring vertex " + vertex + " without references"));
            }
            return;
        }
        if (refns.size() == 0) {
            vertex.compute();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("addReferredNodesToGraph: processing vertex " + vertex + " with " + refns.size() + " references"));
        }
        Enumeration enumeration = refns.elements();
        while (enumeration.hasMoreElements()) {
            Node referencedNode = (Node)enumeration.nextElement();
            Vertex refVertex = this.addVertex(null, referencedNode, null, (short)1, null);
            this.addEdge(refVertex, vertex);
        }
    }

    public void buildBindGraph(Bind bind, Model model) throws XFormsException {
        Instance instance = model.getInstance(bind.getInstanceId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("buildBindGraph: building " + bind));
        }
        List nodeset = bind.getNodeset();
        for (int i = 0; i < nodeset.size(); ++i) {
            Map<String, String> customMIPs;
            BetterFormXPathContext relativeContext = new BetterFormXPathContext(nodeset, i + 1, bind.getPrefixMapping(), bind.getXPathFunctionContext());
            Node node = XPathUtil.getAsNode(nodeset, i + 1);
            ModelItem modelItem = instance.getModelItem(node);
            String property = bind.getCalculate();
            if (property != null) {
                modelItem.getDeclarationView().setCalculate(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)1, bind.getCalculateReferences());
            }
            if ((property = bind.getRelevant()) != null) {
                modelItem.getDeclarationView().setRelevant(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)2, bind.getRelevantReferences());
            }
            if ((property = bind.getReadonly()) != null) {
                modelItem.getDeclarationView().setReadonly(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)3, bind.getReadonlyReferences());
            }
            if ((property = bind.getRequired()) != null) {
                modelItem.getDeclarationView().setRequired(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)4, bind.getRequiredReferences());
            }
            if ((property = bind.getConstraint()) != null) {
                List constraints = bind.getConstraints();
                modelItem.getDeclarationView().setConstraints(constraints);
                modelItem.getDeclarationView().setConstraint(property);
                this.addReferredNodesToGraph(relativeContext, node, property, (short)5, bind.getConstraintReferences());
            }
            if (!(customMIPs = bind.getCustomMIPs()).isEmpty()) {
                modelItem.getDeclarationView().setCustomMIPs(customMIPs);
                for (String key : customMIPs.keySet()) {
                    this.addReferredNodesToGraph(relativeContext, node, customMIPs.get(key), (short)6, bind.getCustomMIPReferences(key), key);
                }
            }
            if ((property = bind.getDatatype()) != null) {
                modelItem.getDeclarationView().setDatatype(property);
            }
            if ((property = bind.getP3PType()) == null) continue;
            modelItem.getDeclarationView().setP3PType(property);
        }
    }
}

