/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.constraints;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RelevanceSelector {
    private static Log LOGGER = LogFactory.getLog(RelevanceSelector.class);

    public static Document selectRelevant(Instance instance) throws XFormsException {
        return RelevanceSelector.selectRelevant(instance, "/");
    }

    public static Document selectRelevant(Instance instance, String path) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("select relevant: processing " + path));
        }
        Document relevantDocument = DOMUtil.newDocument(true, false);
        Element instanceRoot = instance.getInstanceDocument().getDocumentElement();
        Node instanceNode = XPathCache.getInstance().evaluateAsSingleNode(instance.getRootContext(), path);
        if (instanceNode.getNodeType() == 9 && RelevanceSelector.isEnabled(instanceRoot)) {
            RelevanceSelector.addElement(relevantDocument, (Node)instanceRoot);
        }
        if (instanceNode.getNodeType() == 1 && RelevanceSelector.isEnabled(instanceNode)) {
            RelevanceSelector.addElement(relevantDocument, instanceNode);
            NamespaceResolver.applyNamespaces((Element)instanceNode, relevantDocument.getDocumentElement());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"RelevantSelector result document....");
            DOMUtil.prettyPrintDOM(relevantDocument);
        }
        return relevantDocument;
    }

    private static void addElement(Document relevantDocument, Node instanceNode) {
        Element relevantElement = instanceNode.getNamespaceURI() == null ? relevantDocument.createElement(instanceNode.getNodeName()) : relevantDocument.createElementNS(instanceNode.getNamespaceURI(), instanceNode.getNodeName());
        relevantDocument.appendChild(relevantElement);
        RelevanceSelector.addAttributes(relevantElement, instanceNode);
        RelevanceSelector.addChildren(relevantElement, instanceNode);
    }

    private static void addElement(Element relevantParent, Node instanceNode) {
        Document relevantDocument = relevantParent.getOwnerDocument();
        Element relevantElement = instanceNode.getNamespaceURI() == null ? relevantDocument.createElement(instanceNode.getNodeName()) : relevantDocument.createElementNS(instanceNode.getNamespaceURI(), instanceNode.getNodeName());
        relevantElement.setUserData("", instanceNode.getUserData(""), null);
        relevantParent.appendChild(relevantElement);
        RelevanceSelector.addAttributes(relevantElement, instanceNode);
        RelevanceSelector.addChildren(relevantElement, instanceNode);
    }

    private static void addAttributes(Element relevantElement, Node instanceNode) {
        NamedNodeMap instanceAttributes = instanceNode.getAttributes();
        for (int index = 0; index < instanceAttributes.getLength(); ++index) {
            Node instanceAttr = instanceAttributes.item(index);
            if (!RelevanceSelector.isEnabled(instanceAttr)) continue;
            if (instanceAttr.getNamespaceURI() == null) {
                relevantElement.setAttribute(instanceAttr.getNodeName(), instanceAttr.getNodeValue());
                continue;
            }
            relevantElement.setAttributeNS(instanceAttr.getNamespaceURI(), instanceAttr.getNodeName(), instanceAttr.getNodeValue());
        }
    }

    private static void addChildren(Element relevantElement, Node instanceNode) {
        Document ownerDocument = relevantElement.getOwnerDocument();
        NodeList instanceChildren = instanceNode.getChildNodes();
        block5: for (int index = 0; index < instanceChildren.getLength(); ++index) {
            Node instanceChild = instanceChildren.item(index);
            if (!RelevanceSelector.isEnabled(instanceChild)) continue;
            switch (instanceChild.getNodeType()) {
                case 3: {
                    relevantElement.appendChild(ownerDocument.createTextNode(instanceChild.getNodeValue()));
                    continue block5;
                }
                case 4: {
                    relevantElement.appendChild(ownerDocument.createCDATASection(instanceChild.getNodeValue()));
                    continue block5;
                }
                case 1: {
                    RelevanceSelector.addElement(relevantElement, instanceChild);
                    continue block5;
                }
            }
        }
    }

    private static boolean isEnabled(Node nodeImpl) {
        ModelItem item = (ModelItem)nodeImpl.getUserData("");
        return item == null || item.isRelevant();
    }
}

