/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.constraints;

import de.betterform.xml.xforms.model.constraints.CalculateVertex;
import de.betterform.xml.xforms.model.constraints.ConstraintVertex;
import de.betterform.xml.xforms.model.constraints.CustomVertex;
import de.betterform.xml.xforms.model.constraints.DependencyGraph;
import de.betterform.xml.xforms.model.constraints.ReadonlyVertex;
import de.betterform.xml.xforms.model.constraints.RelevantVertex;
import de.betterform.xml.xforms.model.constraints.RequiredVertex;
import de.betterform.xml.xforms.model.constraints.Vertex;
import de.betterform.xml.xpath.impl.saxon.BetterFormXPathContext;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class SubGraph
extends DependencyGraph {
    private static Log LOGGER = LogFactory.getLog(SubGraph.class);

    public void constructSubDependencyGraph(List changedVertices) {
        this.constructSubDependencyGraph(null, changedVertices);
    }

    private void constructSubDependencyGraph(Vertex clonedParent, List changedVertices) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("constructSubDependencyGraph: processing " + (clonedParent != null ? clonedParent + " with " : "") + changedVertices.size() + " changed vertices"));
        }
        for (Vertex originalVertex : changedVertices) {
            int index = this.vertices.indexOf(originalVertex);
            if (index < 0) {
                Vertex clonedVertex = originalVertex.getVertexType() == 6 ? this.createSubVertex(originalVertex.relativeContext, originalVertex.instanceNode, originalVertex.xpathExpression, originalVertex.getVertexType(), ((CustomVertex)originalVertex).getPrefix()) : this.createSubVertex(originalVertex.relativeContext, originalVertex.instanceNode, originalVertex.xpathExpression, originalVertex.getVertexType(), null);
                this.vertices.add(clonedVertex);
                if (clonedParent != null) {
                    clonedParent.addDep(clonedVertex);
                }
                if (originalVertex.depList == null) continue;
                this.constructSubDependencyGraph(clonedVertex, originalVertex.depList);
                continue;
            }
            if (clonedParent == null) continue;
            clonedParent.addDep((Vertex)this.vertices.elementAt(index));
        }
    }

    private Vertex createSubVertex(BetterFormXPathContext relativeContext, Node instanceNode, String expression, short property, String prefix) {
        Vertex v = null;
        switch (property) {
            case 1: {
                v = new CalculateVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 2: {
                v = new RelevantVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 3: {
                v = new ReadonlyVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 5: {
                v = new ConstraintVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 4: {
                v = new RequiredVertex(relativeContext, instanceNode, expression);
                break;
            }
            case 6: {
                v = new CustomVertex(relativeContext, instanceNode, expression, prefix);
            }
        }
        return v;
    }
}

