/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.model.constraints;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.constraints.DefaultValidatorMode;
import de.betterform.xml.xforms.model.constraints.OptimizedValidatorMode;
import de.betterform.xml.xforms.model.constraints.ValidatorMode;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Node;

public class Validator {
    private static Log LOGGER = LogFactory.getLog(Validator.class);
    private static String TYPE_STRING = "string";
    private static String TYPE_NS_STRING = NamespaceResolver.expand("http://www.w3.org/2002/xforms", TYPE_STRING);
    private static String TYPE_DURATION = "duration";
    private static String TYPE_NS_DURATION = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_DURATION);
    private static String TYPE_ENTITY = "ENTITY";
    private static String TYPE_NS_ENTITY = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_ENTITY);
    private static String TYPE_ENTITIES = "ENTITIES";
    private static String TYPE_NS_ENTITIES = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_ENTITIES);
    private static String TYPE_NOTATION = "NOTATION";
    private static String TYPE_NS_NOTATION = NamespaceResolver.expand("http://www.w3.org/2001/XMLSchema", TYPE_NOTATION);
    private Model model;
    private Map datatypes;
    private ValidatorMode mode = new OptimizedValidatorMode();

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Map getDatatypes() {
        return this.datatypes;
    }

    public void setDatatypes(Map datatypes) {
        this.datatypes = datatypes;
    }

    public boolean isKnown(String name) {
        if (this.datatypes == null) {
            return false;
        }
        String expandedName = NamespaceResolver.getExpandedName(this.model.getElement(), name);
        return this.datatypes.get(expandedName) != null;
    }

    public boolean isSupported(String name) {
        String expandedName = NamespaceResolver.getExpandedName(this.model.getElement(), name);
        return !TYPE_DURATION.equals(expandedName) && !TYPE_NS_DURATION.equals(expandedName) && !TYPE_ENTITY.equals(expandedName) && !TYPE_NS_ENTITY.equals(expandedName) && !TYPE_ENTITIES.equals(expandedName) && !TYPE_NS_ENTITIES.equals(expandedName) && !TYPE_NOTATION.equals(expandedName) && !TYPE_NS_NOTATION.equals(expandedName);
    }

    public boolean isRestricted(String base, String restriction) {
        if (this.datatypes == null) {
            return false;
        }
        String baseName = NamespaceResolver.getExpandedName(this.model.getElement(), base);
        XSSimpleType baseType = (XSSimpleType)this.datatypes.get(baseName);
        if (baseType == null) {
            return false;
        }
        String restrictionName = NamespaceResolver.getExpandedName(this.model.getElement(), restriction);
        Object restrictionType = this.datatypes.get(restrictionName);
        if (restrictionType == null) {
            return false;
        }
        if (restrictionType instanceof XSSimpleTypeDecl) {
            return ((XSSimpleTypeDecl)restrictionType).isDOMDerivedFrom(baseType.getNamespace(), baseType.getName(), 16);
        }
        if (restrictionType instanceof XSComplexTypeDecl) {
            return ((XSComplexTypeDecl)restrictionType).isDOMDerivedFrom(baseType.getNamespace(), baseType.getName(), 16);
        }
        return ((XSSimpleType)restrictionType).derivedFromType((XSTypeDefinition)baseType, (short)2);
    }

    public void validate(Instance instance) throws XFormsException {
        this.validate(instance, instance.getInstanceNodeset(), 1, "/", Collections.EMPTY_MAP, null, this.model.isReady() ? this.mode : new DefaultValidatorMode());
    }

    public void validate(Instance instance, List instanceNodeset, int position, String path, Map prefixMapping, XPathFunctionContext xpathFunctionContext, ValidatorMode mode) throws XFormsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("validate Instance '" + instance.getId() + "' in " + mode + " mode"));
        }
        Iterator iterator = instance.iterateModelItems(instanceNodeset, position, path, prefixMapping, xpathFunctionContext, true);
        while (iterator.hasNext()) {
            ModelItem modelItem = (ModelItem)iterator.next();
            if (mode.performValidation(modelItem)) {
                this.validate(modelItem);
            }
            if (mode.continueValidation(modelItem)) continue;
            return;
        }
    }

    public void validate(ModelItem modelItem) {
        String xfType;
        String value = modelItem.getValue();
        if (modelItem.isXSINillable() && (value == null || value.length() == 0)) {
            if (LOGGER.isTraceEnabled()) {
                String xsiPrefix = NamespaceResolver.getPrefix(this.model.getElement(), "http://www.w3.org/2001/XMLSchema-instance");
                LOGGER.trace((Object)("validate: item " + modelItem.getNode() + " with @" + xsiPrefix + ":nil='true' considered valid"));
            }
            modelItem.getLocalUpdateView().setDatatypeValid(true);
            return;
        }
        boolean datatypeValid = true;
        String xsiType = this.expandName(modelItem.getXSIType());
        if (xsiType != null && !this.isDefaultType(xsiType) && this.isKnown(modelItem.getXSIType())) {
            datatypeValid = this.checkDatatype(xsiType, value);
        }
        if ((xfType = this.expandName(modelItem.getDeclarationView().getDatatype())) != null && !this.isDefaultType(xfType)) {
            datatypeValid &= this.checkDatatype(xfType, value);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("validate: " + DOMUtil.getCanonicalPath((Node)modelItem.getNode()) + " computed " + (datatypeValid ? "valid" : "INVALID")));
        }
        modelItem.getLocalUpdateView().setDatatypeValid(datatypeValid);
    }

    private String expandName(String datatype) {
        return datatype != null ? NamespaceResolver.getExpandedName(this.model.getElement(), datatype) : null;
    }

    private boolean isDefaultType(String expandedName) {
        return TYPE_STRING.equals(expandedName) || TYPE_NS_STRING.equals(expandedName);
    }

    private boolean checkDatatype(String expandedName, String value) {
        XSSimpleType simpleType = (XSSimpleType)this.datatypes.get(expandedName);
        ValidatedInfo validatedInfo = new ValidatedInfo();
        ValidationState validationState = new ValidationState();
        validationState.setFacetChecking(true);
        validationState.setExtraChecking(false);
        validationState.setUsingNamespaces(true);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("checking datatype - expandedName: " + expandedName));
        }
        if (expandedName.endsWith("QName") && value.indexOf(":") != -1) {
            NamespaceSupport support = new NamespaceSupport();
            support.pushContext();
            String nsPrefix = value.substring(0, value.indexOf(":")).intern();
            Map namespaces = NamespaceResolver.getAllNamespaces(this.model.getElement());
            String nsURI = (String)namespaces.get(nsPrefix);
            if (nsPrefix != null && nsURI != null) {
                support.declarePrefix(nsPrefix, nsURI);
                validationState.setNamespaceSupport((NamespaceContext)support);
            }
        }
        try {
            simpleType.validate(value.intern(), (ValidationContext)validationState, validatedInfo);
        }
        catch (InvalidDatatypeValueException e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace((Object)("value '" + value + "' of type " + expandedName + " is invalid - " + e.getMessage()));
            }
            return false;
        }
        return true;
    }
}

