/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.config.Config;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.DefaultAction;
import de.betterform.xml.xforms.XFormsProcessorImpl;
import de.betterform.xml.xforms.action.UpdateHandler;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.BoundElementState;
import de.betterform.xml.xforms.ui.state.UIElementStateUtil;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.InputMismatchException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;

public abstract class AbstractFormControl
extends BindingElement
implements DefaultAction {
    private static Log LOGGER = LogFactory.getLog(AbstractFormControl.class);

    public AbstractFormControl(Element element, Model model) {
        super(element, model);
    }

    public abstract void setValue(String var1) throws XFormsException;

    public Object getValue() {
        if (this.elementState != null) {
            return this.elementState.getValue();
        }
        return null;
    }

    public Object getSchemaValue() {
        if (this.elementState != null) {
            return this.elementState.getSchemaValue();
        }
        return null;
    }

    public String getDatatype() throws XFormsException {
        if (this.hasBindingExpression()) {
            ModelItem modelItem;
            Node n = this.getInstanceNode();
            if (n == null) {
                this.getLogger().warn((Object)("Node for path '" + this.getBindingExpression() + "' does not exist:" + DOMUtil.getCanonicalPath(this.element)));
            }
            if ((modelItem = this.model.getInstance(this.getInstanceId()).getModelItem(n)) != null) {
                return UIElementStateUtil.getDatatype(modelItem, this.element);
            }
            return "string";
        }
        return null;
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.initializeActions();
    }

    @Override
    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-previous", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-next", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-focus", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-help", this);
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-hint", this);
    }

    @Override
    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-binding-exception", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-previous", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-next", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-focus", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-help", this);
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-hint", this);
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return this.hasBindingExpression() ? new BoundElementState() : null;
    }

    protected void dispatchValueChangeSequence() throws XFormsException {
        UpdateHandler updateHandler;
        if (this.elementState != null) {
            this.elementState.setProperty("dispatchValueChange", Boolean.FALSE);
        }
        if ((updateHandler = this.model.getUpdateHandler()) == null) {
            this.container.dispatch(this.model.getTarget(), "xforms-recalculate", null);
            this.container.dispatch(this.model.getTarget(), "xforms-revalidate", null);
            this.container.dispatch(this.model.getTarget(), "xforms-refresh", null);
        } else {
            updateHandler.doRecalculate(true);
            updateHandler.doRevalidate(true);
            updateHandler.doRefresh(true);
        }
        if (this.elementState != null) {
            this.elementState.setProperty("dispatchValueChange", Boolean.TRUE);
        }
    }

    @Override
    public void performDefault(Event event) {
        super.performDefault(event);
        if (this.isCancelled(event)) {
            this.getLogger().debug((Object)(this + " event " + event.getType() + " cancelled"));
            return;
        }
        if (event.getType().equals("xforms-previous")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-next")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-focus")) {
            return;
        }
        if (event.getType().equals("xforms-help")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
        if (event.getType().equals("xforms-hint")) {
            this.getLogger().warn((Object)(this + " default action for " + event.getType() + " is not implemented yet"));
            return;
        }
    }

    protected String delocaliseValue(String value) throws XFormsException, ParseException {
        if (value == null || value.equals("")) {
            return value;
        }
        if (Config.getInstance().getProperty("enable.l10n").equals("true")) {
            Locale locale = (Locale)this.getModel().getContainer().getProcessor().getContext().get("betterform.locale");
            XFormsProcessorImpl processor = this.model.getContainer().getProcessor();
            if (processor.hasControlType(this.id, "xs:float") || processor.hasControlType(this.id, "xs:decimal") || processor.hasControlType(this.id, "xs:double")) {
                BigDecimal number;
                NumberFormat formatter = NumberFormat.getNumberInstance(locale);
                formatter.setMaximumFractionDigits(64);
                try {
                    number = this.strictParse(value, locale);
                }
                catch (ParseException e) {
                    LOGGER.warn((Object)("value: '" + value + "' could not be parsed for locale: " + locale));
                    return value;
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn((Object)("value: '" + value + "' could not be parsed for locale: " + locale));
                    return value;
                }
                catch (InputMismatchException ime) {
                    LOGGER.warn((Object)("value: '" + value + "' could not be parsed for locale: " + locale));
                    return value;
                }
                return number.toPlainString();
            }
            if (processor.hasControlType(this.id, "xs:date")) {
                DateFormat df = DateFormat.getDateInstance(2, locale);
                Date d = null;
                try {
                    d = df.parse(value);
                }
                catch (ParseException e) {
                    df = new SimpleDateFormat("yyyy-MM-dd");
                    df.setLenient(false);
                    d = df.parse(value);
                }
                df = new SimpleDateFormat("yyyy-MM-dd");
                return df.format(d);
            }
            if (processor.hasControlType(this.id, "xs:dateTime")) {
                String timezone = "";
                if (value.contains("GMT")) {
                    timezone = value.substring(value.indexOf("GMT") + 3, value.length());
                } else if (value.contains("+")) {
                    timezone = value.substring(value.indexOf("+"), value.length());
                } else if (value.contains("Z")) {
                    timezone = "Z";
                }
                DateFormat sf = DateFormat.getDateTimeInstance(2, 2, locale);
                Date d = null;
                try {
                    d = sf.parse(value);
                }
                catch (ParseException e) {
                    sf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    d = null;
                    d = sf.parse(value);
                }
                sf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                String converted = sf.format(d);
                if (!timezone.equals("")) {
                    return converted + timezone;
                }
                return converted;
            }
        }
        return value;
    }

    private BigDecimal strictParse(String value, Locale locale) throws ParseException {
        boolean okay;
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(locale);
        format.setParseBigDecimal(true);
        value = value.trim();
        ParsePosition pos = new ParsePosition(0);
        BigDecimal number = (BigDecimal)format.parse(value, pos);
        boolean bl = okay = pos.getIndex() == value.length() && pos.getErrorIndex() == -1;
        if (!okay) {
            throw new ParseException("Could not parse '" + value + "' as a number", pos.getErrorIndex());
        }
        return number;
    }
}

