/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.xforms.Initializer;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.Repeat;
import de.betterform.xml.xforms.ui.RepeatItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractUIElement
extends XFormsElement {
    protected static Log LOGGER = LogFactory.getLog(AbstractUIElement.class);
    protected String repeatItemId;

    public AbstractUIElement(Element element, Model model) {
        super(element, model);
    }

    public void setRepeatItemId(String repeatItemId) throws XFormsException {
        this.repeatItemId = repeatItemId;
    }

    public String getRepeatItemId() {
        return this.repeatItemId;
    }

    public boolean isRepeated() {
        return this.repeatItemId != null;
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeChildren();
    }

    public void refresh() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateChildren();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeChildren();
        this.disposeSelf();
    }

    public String getTargetReference() {
        if (this.isRepeated()) {
            return this.getTargetReference(this.element, this.id);
        }
        return this.id;
    }

    protected String getTargetReference(Element node, String targetRef) {
        int position;
        if (node == null) {
            return targetRef;
        }
        if (!(node instanceof Element)) {
            return targetRef;
        }
        Object xfObject = node.getUserData("");
        if (xfObject != null && xfObject instanceof RepeatItem) {
            position = ((RepeatItem)xfObject).getPosition();
            targetRef = "," + position + "]/" + targetRef;
        } else if (xfObject != null && xfObject instanceof Repeat) {
            position = ((Repeat)xfObject).getPosition();
            targetRef = "[" + position + "" + targetRef;
        }
        Node parent = node.getParentNode();
        if (parent.getNodeType() == 9 || parent.getNodeType() == 11 || parent == null) {
            return "/" + targetRef;
        }
        if (parent.getNodeType() == 1) {
            return this.getTargetReference((Element)parent, targetRef);
        }
        LOGGER.warn((Object)("Unkown type: " + parent));
        return targetRef;
    }

    protected final void initializeActions() throws XFormsException {
        Initializer.initializeActionElements(this.model, this.element, this.repeatItemId);
    }

    protected final void initializeChildren() throws XFormsException {
        Initializer.initializeUIElements(this.model, this.element, this.repeatItemId, this.element.getOwnerDocument().getDocumentElement().getAttributeNS("http://betterform.sourceforge.net/xforms", "evalAVTs"));
    }

    protected void updateChildren() throws XFormsException {
        Initializer.updateUIElements(this.element, this.model);
    }

    protected final void disposeChildren() throws XFormsException {
        Initializer.disposeUIElements(this.element);
    }

    protected final void disposeSelf() {
        this.element.setUserData("", null, null);
        this.deregister();
    }
}

