/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.DefaultAction;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.bind.Bind;
import de.betterform.xml.xforms.model.bind.Binding;
import de.betterform.xml.xforms.model.bind.BindingResolver;
import de.betterform.xml.xforms.model.bind.BindingUtil;
import de.betterform.xml.xforms.ui.AbstractUIElement;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public abstract class BindingElement
extends AbstractUIElement
implements Binding,
DefaultAction {
    private static final Log LOGGER = LogFactory.getLog(BindingElement.class);
    protected String instanceId = null;
    protected String locationPath = null;
    protected List nodeset;
    protected int position = 1;
    protected UIElementState elementState = null;
    protected Map attributeValueMap;
    private String allowedAttributes;

    public BindingElement(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        String[] attrs;
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.updateXPathContext();
        this.initializeElementState();
        this.initializeChildren();
        this.allowedAttributes = this.getElement().getOwnerDocument().getDocumentElement().getAttributeNS("http://betterform.sourceforge.net/xforms", "evalAVTs");
        for (String attribute : attrs = this.allowedAttributes.split(" ")) {
            if (!this.getElement().hasAttribute(attribute) || this.getElement().getAttribute(attribute).indexOf("{") == -1) continue;
            this.attributeValueMap = new HashMap(attrs.length);
            String expression = this.getElement().getAttribute(attribute);
            this.attributeValueMap.put(attribute, expression);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.debug((Object)("evaluating AVT at: " + DOMUtil.getCanonicalPath(this.getElement()) + "/@" + attribute));
                DOMUtil.prettyPrintDOM(this.element);
            }
            String result = this.evalAttributeValueTemplates(expression, this.getElement());
            this.getElement().setAttribute(attribute, result.toString());
        }
    }

    public String evalAttributeValueTemplates(String inputExpr, Element element) throws XFormsException {
        String toReplace = inputExpr;
        String value = "";
        StringBuffer substitutedString = new StringBuffer();
        boolean hasTokens = true;
        while (hasTokens) {
            int start = toReplace.indexOf("{");
            int end = toReplace.indexOf(125);
            if (start == -1 || end == -1) {
                hasTokens = false;
                substitutedString.append(toReplace);
                continue;
            }
            substitutedString.append(toReplace.substring(0, start));
            String valueTemplate = toReplace.substring(start + 1, end);
            if (valueTemplate.startsWith("$")) {
                valueTemplate = valueTemplate.substring(1);
                if (this.model.getContainer().getProcessor().getContext().containsKey(valueTemplate)) {
                    value = this.model.getContainer().getProcessor().getContext().get(valueTemplate).toString();
                }
            } else {
                value = XPathCache.getInstance().evaluateAsString(this.getNodeset(), this.getPosition(), valueTemplate, this.getPrefixMapping(), this.xpathFunctionContext);
            }
            if (value == null) {
                throw new XFormsComputeException("valueTemplate could not be evaluated.", (EventTarget)((Object)element), (Object)"");
            }
            if (value.equals("")) {
                LOGGER.warn((Object)("valueTemplate could not be evaluated. Replacing '" + valueTemplate + "' with empty string"));
            }
            substitutedString.append(value);
            toReplace = toReplace.substring(end + 1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("inputExpr: '" + inputExpr + "' evaluated to: '" + substitutedString + "'"));
        }
        return substitutedString.toString();
    }

    @Override
    public void refresh() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("refresh" + this));
        }
        this.updateXPathContext();
        this.updateElementState();
        if (this.attributeValueMap != null) {
            Set keyset = this.attributeValueMap.keySet();
            for (String attribute : keyset) {
                String result = this.evalAttributeValueTemplates((String)this.attributeValueMap.get(attribute), this.getElement());
                this.getElement().setAttribute(attribute, result.toString());
                HashMap<String, String> contextInfo = new HashMap<String, String>(2);
                contextInfo.put("attribute", attribute);
                contextInfo.put("value", result);
                this.container.dispatch(this.getTarget(), "betterform-AVT-changed", contextInfo);
            }
        }
        this.updateChildren();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeSelf();
    }

    @Override
    public String getBindingExpression() {
        if (this.hasModelBinding()) {
            return this.getModelBinding().getBindingExpression();
        }
        if (BindingUtil.hasRef(this.element)) {
            return this.getXFormsAttribute("ref");
        }
        return this.getXFormsAttribute("nodeset");
    }

    @Override
    public String getBindingId() {
        Bind bind = this.getModelBinding();
        if (bind != null) {
            return bind.getId();
        }
        return this.id;
    }

    @Override
    public Binding getEnclosingBinding() {
        return this.getEnclosingBinding(this, true);
    }

    @Override
    public String getLocationPath() {
        if (!this.hasBindingExpression()) {
            return null;
        }
        if (this.isRepeated()) {
            return BindingResolver.getExpressionPath(this, this.getRepeatItemId());
        }
        if (this.locationPath == null) {
            this.locationPath = BindingResolver.getExpressionPath(this, null);
        }
        return this.locationPath;
    }

    @Override
    public String getModelId() {
        return this.model.getId();
    }

    @Override
    public void performDefault(Event event) {
        if (event.getType().equals("xforms-binding-exception")) {
            this.getLogger().error((Object)(this + " binding exception: " + ((XMLEvent)event).getContextInfo()));
        }
    }

    @Override
    public boolean hasBindingExpression() {
        return this.hasModelBinding() || this.hasUIBinding();
    }

    @Override
    public String getInstanceId() throws XFormsException {
        if (this.instanceId == null) {
            this.instanceId = this.model.computeInstanceId(this.getLocationPath());
        }
        return this.instanceId;
    }

    public String getInstanceValue() throws XFormsException {
        return XPathUtil.getAsString(this.getNodeset(), this.getPosition());
    }

    public Node getInstanceNode() throws XFormsException {
        return XPathUtil.getAsNode(this.getNodeset(), this.getPosition());
    }

    protected boolean hasUIBinding() {
        return this.getXFormsAttribute("ref") != null;
    }

    protected boolean hasModelBinding() {
        return this.getXFormsAttribute("bind") != null;
    }

    protected Bind getModelBinding() {
        String bindAttribute = this.getXFormsAttribute("bind");
        if (bindAttribute != null) {
            return (Bind)this.container.lookup(bindAttribute);
        }
        return null;
    }

    protected void initializeDefaultAction() {
        this.container.getXMLEventService().registerDefaultAction(this.target, "xforms-binding-exception", this);
    }

    protected final void initializeInstanceNode() throws XFormsException {
        if (this.hasBindingExpression()) {
            String instanceId = this.getInstanceId();
            Instance instance = this.getModel().getInstance(instanceId);
            if (instance == null) {
                instance = this.model.addInstance(instanceId);
            }
            this.updateXPathContext();
            if (this.nodeset.size() == 0 && !instance.hasInitialInstance()) {
                List parentNodeset = this.evalInScopeContext();
                if (parentNodeset.size() == 0) {
                    instance.createRootElement("instanceData");
                    parentNodeset = this.evalInScopeContext();
                    instance.setLazyXPathContext(parentNodeset);
                }
                instance.createNode(parentNodeset, this.getPosition(), this.getBindingExpression());
                this.updateXPathContext();
            }
        }
    }

    protected final void initializeElementState() throws XFormsException {
        this.elementState = this.createElementState();
        if (this.elementState != null) {
            this.elementState.setOwner(this);
            this.elementState.init();
        }
    }

    protected void updateXPathContext() throws XFormsException {
        List resultNodeset;
        if (this.hasModelBinding() && this.getModelBinding().getEnclosingBinding() != null && !this.isRepeated()) {
            Bind binding = this.getModelBinding();
            binding.getEnclosingBinding().getNodeset();
            resultNodeset = binding.getEnclosingBinding().getNodeset();
        } else {
            resultNodeset = this.evalInScopeContext();
        }
        String relativeExpr = this.getBindingExpression();
        try {
            this.nodeset = relativeExpr != null ? XPathCache.getInstance().evaluate(resultNodeset, this.getPosition(), relativeExpr, this.getPrefixMapping(), this.xpathFunctionContext) : resultNodeset;
        }
        catch (XFormsException e) {
            throw new XFormsBindingException(e.getMessage(), this.target, null);
        }
    }

    @Override
    public List getNodeset() {
        return this.nodeset;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    protected final void updateElementState() throws XFormsException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.debug((Object)">>> before update <<<");
            DOMUtil.prettyPrintDOM(this.element);
        }
        if (this.elementState != null) {
            this.elementState.update();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.debug((Object)">>> after update <<<");
            DOMUtil.prettyPrintDOM(this.element);
        }
    }

    protected final void disposeElementState() throws XFormsException {
        if (this.elementState != null) {
            this.elementState.dispose();
            this.elementState = null;
        }
    }

    protected void disposeDefaultAction() {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "xforms-binding-exception", this);
    }

    public String getNodeValue() throws XFormsException {
        return this.model.getInstance(this.instanceId).getNodeValue(XPathUtil.getAsNode(this.getNodeset(), this.getPosition()));
    }

    public void setNodeValue(String value) throws XFormsException {
        this.model.getInstance(this.instanceId).setNodeValue(XPathUtil.getAsNode(this.getNodeset(), this.getPosition()), value);
    }

    public ModelItem getModelItem() {
        return this.model.getInstance(this.instanceId).getModelItem(XPathUtil.getAsNode(this.getNodeset(), this.getPosition()));
    }

    protected abstract UIElementState createElementState() throws XFormsException;

    public UIElementState getUIElementState() {
        return this.elementState;
    }
}

