/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.events.impl.XercesXMLEvent;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.XFormsElementFactory;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.bind.Bind;
import de.betterform.xml.xforms.model.bind.BindingResolver;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.RepeatItem;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.RepeatElementState;
import de.betterform.xml.xpath.XPathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.saxon.dom.DOMNodeWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class Repeat
extends BindingElement
implements EventListener {
    private static final Log LOGGER = LogFactory.getLog(Repeat.class);
    private int startIndex;
    private int index;
    private Element prototype;
    private List items;

    public Repeat(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void handleEvent(Event event) {
        try {
            String instancePath = (String)((XercesXMLEvent)event).getContextInfo().get("canonPath");
            instancePath = instancePath.substring(0, instancePath.lastIndexOf("["));
            if (this.nodeset.size() == 0) {
                return;
            }
            Node n = (Node)((DOMNodeWrapper)this.nodeset.get(0)).getUnderlyingNode();
            String path = DOMUtil.getCanonicalPath(n);
            if (instancePath.equals(path = path.substring(0, path.lastIndexOf("[")))) {
                if ("betterform-node-inserted".equals(event.getType())) {
                    this.handleNodeInserted(event);
                    return;
                }
                if ("betterform-node-deleted".equals(event.getType())) {
                    this.handleNodeDeleted(event);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.container.handleEventException(e);
            event.preventDefault();
            event.stopPropagation();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " set index: " + index));
        }
        if (this.index != index) {
            this.index = index;
            this.notifyIndexChange();
        }
        if (this.isRepeated()) {
            RepeatItem repeatItem = (RepeatItem)this.container.lookup(this.getRepeatItemId());
            repeatItem.getRepeat().setIndex(repeatItem.getPosition());
        } else {
            this.registerRepeatItem(index);
        }
    }

    public int getContextSize() {
        if (this.hasBindingExpression()) {
            return this.getNodeset().size();
        }
        return 0;
    }

    public RepeatItem getRepeatItem(int position) {
        if (position > 0 && position <= this.items.size()) {
            return (RepeatItem)this.items.get(position - 1);
        }
        return null;
    }

    public Element getPrototype() {
        return this.prototype;
    }

    @Override
    public boolean hasModelBinding() {
        return this.getXFormsAttribute("repeat-bind") != null || this.getXFormsAttribute("bind") != null;
    }

    @Override
    public boolean hasUIBinding() {
        return this.getXFormsAttribute("repeat-ref") != null || this.getXFormsAttribute("repeat-nodeset") != null || this.getXFormsAttribute("ref") != null || this.getXFormsAttribute("nodeset") != null;
    }

    @Override
    public Bind getModelBinding() {
        String bindAttribute = this.getXFormsAttribute("repeat-bind");
        if (bindAttribute != null) {
            return (Bind)this.container.lookup(bindAttribute);
        }
        return super.getModelBinding();
    }

    @Override
    public String getBindingExpression() {
        if (this.hasModelBinding()) {
            return this.getModelBinding().getBindingExpression();
        }
        String refAttribute = this.getXFormsAttribute("ref");
        if (refAttribute != null) {
            return refAttribute;
        }
        refAttribute = this.getXFormsAttribute("repeat-ref");
        if (refAttribute != null) {
            return refAttribute;
        }
        String nodesetAttribute = this.getXFormsAttribute("repeat-nodeset");
        if (nodesetAttribute != null) {
            return nodesetAttribute;
        }
        nodesetAttribute = this.getXFormsAttribute("nodeset");
        if (nodesetAttribute != null) {
            return nodesetAttribute;
        }
        return null;
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        try {
            this.startIndex = this.getXFormsAttribute("startindex") != null ? Integer.parseInt(this.getXFormsAttribute("startindex")) : (this.getXFormsAttribute("repeat-startindex") != null ? Integer.parseInt(this.getXFormsAttribute("repeat-startindex")) : 1);
        }
        catch (NumberFormatException e) {
            this.startIndex = 1;
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.updateXPathContext();
        this.initializePrototype();
        this.initializeElementState();
        this.initializeRepeat();
    }

    @Override
    public void refresh() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " update"));
        }
        this.updateXPathContext();
        this.updateRepeat();
        this.updateElementState();
        this.updateChildren();
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeRepeat();
        this.disposeSelf();
    }

    @Override
    protected UIElementState createElementState() throws XFormsException {
        return this.hasBindingExpression() ? new RepeatElementState() : null;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    protected void initializePrototype() throws XFormsException {
        Document document = this.element.getOwnerDocument();
        this.prototype = document.createElementNS("http://www.w3.org/2002/xforms", (this.xformsPrefix != null ? this.xformsPrefix : "xf") + ":" + "group");
        this.prototype.setAttributeNS(null, "id", this.container.generateId());
        this.prototype.setAttributeNS(null, "appearance", "repeated");
        NodeList children = this.element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            this.initializePrototype(this.prototype, children.item(index));
        }
        DOMUtil.removeAllChildren(this.element);
    }

    protected void initializeRepeat() throws XFormsException {
        Instance instance = this.model.getInstance(this.getInstanceId());
        instance.getTarget().addEventListener("betterform-node-inserted", this, false);
        instance.getTarget().addEventListener("betterform-node-deleted", this, false);
        int count = this.getContextSize();
        this.items = new ArrayList(count);
        if (count > 0) {
            this.index = Math.min(count, this.startIndex);
        }
        if (this.element.hasAttributeNS("http://betterform.sourceforge.net/xforms", "index")) {
            this.index = Integer.parseInt(this.element.getAttributeNS("http://betterform.sourceforge.net/xforms", "index"));
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " init: initializing " + count + " repeat item(s)"));
        }
        for (int position = 1; position < count + 1; ++position) {
            this.items.add(this.initializeRepeatItem(position));
        }
        if (count > 0) {
            this.registerRepeatItem(this.index);
            this.notifyIndexChange();
        }
    }

    protected void updateRepeat() throws XFormsException {
        int position;
        int uiSize;
        int contextSize = this.getContextSize();
        if (contextSize < (uiSize = this.items.size())) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " update: disposing " + (uiSize - contextSize) + " repeat item(s)"));
            }
            for (position = uiSize; position > contextSize; --position) {
                this.disposeRepeatItem((RepeatItem)this.items.remove(position - 1));
            }
            if (this.getIndex() > contextSize) {
                this.setIndex(contextSize);
            }
        }
        if (contextSize > uiSize) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " update: initializing " + (contextSize - uiSize) + " repeat item(s)"));
            }
            for (position = uiSize + 1; position <= contextSize; ++position) {
                this.items.add(this.initializeRepeatItem(position));
            }
            if (this.getIndex() == 0) {
                this.setIndex(1);
            }
        }
    }

    protected void disposeRepeat() throws XFormsException {
        Instance instance = this.model.getInstance(this.getInstanceId());
        if (instance != null) {
            instance.getTarget().removeEventListener("betterform-node-inserted", this, false);
            instance.getTarget().removeEventListener("betterform-node-deleted", this, false);
        }
        this.items.clear();
        this.items = null;
        this.prototype = null;
    }

    protected void handleNodeInserted(Event event) throws XFormsException {
        if (this.doHandleInstanceEvent(event)) {
            int contextPosition = Integer.parseInt(String.valueOf(((XMLEvent)event).getContextInfo("position")));
            int uiPosition = this.computeUIPosition(contextPosition);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " insert: position " + uiPosition));
            }
            this.items.add(uiPosition - 1, this.initializeRepeatItem(uiPosition));
            for (int index = uiPosition; index < this.items.size(); ++index) {
                ((RepeatItem)this.items.get(index)).setPosition(index + 1);
            }
            this.setIndex(uiPosition);
        }
    }

    protected void handleNodeDeleted(Event event) throws XFormsException {
        if (this.doHandleInstanceEvent(event)) {
            int contextPosition = Integer.parseInt(String.valueOf(((XMLEvent)event).getContextInfo("position")));
            int uiPosition = this.computeUIPosition(contextPosition);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this + " delete: position " + uiPosition));
            }
            this.disposeRepeatItem((RepeatItem)this.items.remove(uiPosition - 1));
            for (int index = uiPosition - 1; index < this.items.size(); ++index) {
                ((RepeatItem)this.items.get(index)).setPosition(index + 1);
            }
            int contextSize = this.getContextSize();
            if (this.getIndex() > contextSize) {
                this.setIndex(contextSize);
                this.container.setFocussedContainerId(((RepeatItem)this.items.get(contextSize - 1)).getId());
            } else if (this.getIndex() != 0) {
                this.container.setFocussedContainerId(((RepeatItem)this.items.get(this.getIndex() - 1)).getId());
            } else {
                this.container.setFocussedContainerId(null);
            }
        } else {
            this.setIndex(this.index);
            this.container.setFocussedContainerId(null);
        }
    }

    private boolean doHandleInstanceEvent(Event event) throws XFormsException {
        this.updateXPathContext();
        int contextSize = this.getContextSize();
        if (contextSize == 0) {
            return false;
        }
        String canonicalPath = BindingResolver.getCanonicalPath(de.betterform.xml.xpath.impl.saxon.XPathUtil.getAsNode(this.getNodeset(), this.getPosition()));
        String canonicalNodeset = XPathUtil.getNodesetAndPredicates(canonicalPath)[0];
        String eventNodeset = String.valueOf(((XMLEvent)event).getContextInfo("nodeset"));
        String locationPath = this.getLocationPath();
        if (!canonicalNodeset.equals(eventNodeset) && !locationPath.equals(eventNodeset)) {
            return false;
        }
        int uiSize = this.items.size();
        return contextSize != uiSize;
    }

    private int computeUIPosition(int contextPosition) {
        int contextFirst = 0;
        int contextLast = 0;
        if (this.items.size() > 0) {
            contextFirst = ((RepeatItem)this.items.get(0)).getContextPosition();
            contextLast = ((RepeatItem)this.items.get(this.items.size() - 1)).getContextPosition();
        }
        if (contextPosition <= contextFirst) {
            return 1;
        }
        if (contextPosition > contextLast) {
            return this.items.size() + 1;
        }
        RepeatItem repeatItem = (RepeatItem)this.items.get(0);
        for (int index = 1; index < this.items.size() && repeatItem.getContextPosition() < contextPosition; ++index) {
            repeatItem = (RepeatItem)this.items.get(index);
        }
        return repeatItem.getPosition();
    }

    private void notifyIndexChange() throws XFormsException {
        this.elementState.setProperty("index", new Integer(this.index));
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("index", String.valueOf(this.index));
            this.container.dispatch(this.target, "betterform-index-changed", map);
        }
    }

    private void initializePrototype(Node parent, Node prototype) {
        Node copy = prototype.cloneNode(false);
        if (copy.getNodeType() == 1) {
            Element element = (Element)copy;
            if (element.getAttributeNS(null, "id").length() == 0 && XFormsElementFactory.isUIElement(element)) {
                element.setAttributeNS(null, "id", this.container.generateId());
            }
            NodeList children = prototype.getChildNodes();
            for (int index = 0; index < children.getLength(); ++index) {
                this.initializePrototype(element, children.item(index));
            }
        }
        parent.appendChild(copy);
    }

    private RepeatItem initializeRepeatItem(int position) throws XFormsException {
        Node before = DOMUtil.findNthChildNS(this.element, "http://www.w3.org/2002/xforms", "group", position);
        if (before == null) {
            before = DOMUtil.findFirstChildNS(this.element, "http://betterform.sourceforge.net/xforms", "data");
        }
        Element group = (Element)this.prototype.cloneNode(true);
        this.element.insertBefore(group, before);
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("prototypeId", this.prototype.getAttributeNS(null, "id"));
            this.container.dispatch(this.target, "betterform-prototype-cloned", map);
        }
        RepeatItem repeatItem = (RepeatItem)this.container.getElementFactory().createXFormsElement(group, this.getModel());
        repeatItem.setRepeat(this);
        repeatItem.setPosition(position);
        repeatItem.setGeneratedId(this.container.generateId());
        repeatItem.registerId();
        repeatItem.init();
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("position", String.valueOf(position));
            this.container.dispatch(this.target, "betterform-item-inserted", map);
        }
        return repeatItem;
    }

    private void disposeRepeatItem(RepeatItem repeatItem) throws XFormsException {
        Element element = repeatItem.getElement();
        int position = repeatItem.getPosition();
        repeatItem.dispose();
        this.element.removeChild(element);
        if (this.model.isReady()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("originalId", this.originalId != null ? this.originalId : this.id);
            map.put("position", String.valueOf(position));
            this.container.dispatch(this.target, "betterform-item-deleted", map);
        }
    }

    private void registerRepeatItem(int position) {
        RepeatItem repeatItem = this.getRepeatItem(position);
        if (repeatItem != null) {
            repeatItem.registerId();
            this.registerChildren(repeatItem.getElement());
        }
    }

    private void registerChildren(Node parent) {
        NodeList childNodes = parent.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node node = childNodes.item(index);
            if (!(node instanceof Element)) continue;
            Element elementImpl = (Element)node;
            XFormsElement xFormsElement = (XFormsElement)elementImpl.getUserData("");
            if (xFormsElement != null) {
                xFormsElement.registerId();
                if (xFormsElement instanceof Repeat) {
                    Repeat repeat = (Repeat)xFormsElement;
                    RepeatItem repeatItem = repeat.getRepeatItem(repeat.getIndex());
                    if (repeatItem == null) continue;
                    repeatItem.registerId();
                    this.registerChildren(repeatItem.getElement());
                    continue;
                }
                this.registerChildren(xFormsElement.getElement());
                continue;
            }
            this.registerChildren(node);
        }
    }
}

