/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.dom.DOMComparator;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.events.XMLEvent;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.ui.AbstractFormControl;
import de.betterform.xml.xforms.ui.Copy;
import de.betterform.xml.xforms.ui.Item;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.saxon.om.NodeInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;

public class Selector
extends AbstractFormControl {
    private static final Log LOGGER = LogFactory.getLog(Selector.class);
    private boolean copySkeleton = false;
    private boolean multiple;
    private final Map extendedPrefixMapping = new HashMap(this.prefixMapping);
    private boolean selectHasCopyChilds = false;
    private boolean isOutOfRange = false;

    public Selector(Element element, Model model) {
        super(element, model);
        this.extendedPrefixMapping.put("bf", "http://betterform.sourceforge.net/xforms");
        this.extendedPrefixMapping.put("xf", "http://www.w3.org/2002/xforms");
        this.container.getXMLEventService().registerDefaultAction(this.target, "DOMActivate", this);
    }

    @Override
    public void dispose() throws XFormsException {
        this.container.getXMLEventService().deregisterDefaultAction(this.target, "DOMActivate", this);
        super.dispose();
    }

    @Override
    public void performDefault(Event event) {
        super.performDefault(event);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Selector: perform default event:" + event.getType()));
        }
        XMLEvent ev = (XMLEvent)event;
        String contextInfo = (String)ev.getContextInfo().get("context-info");
        ArrayList<Object> list = new ArrayList<Object>();
        if (contextInfo != null) {
            StringTokenizer tokens = new StringTokenizer(contextInfo, ";");
            while (tokens.hasMoreTokens()) {
                list.add(tokens.nextElement());
            }
        }
        Iterator iterator = null;
        List elemContext = XPathUtil.getElementContext(this.getElement(), this.container.getProcessor().getBaseURI());
        String xformsPrefix = null;
        xformsPrefix = this.xformsPrefix != null ? this.xformsPrefix : "xf";
        String xpath = "(" + xformsPrefix + ":" + "item" + " | *//" + xformsPrefix + ":" + "item" + "[not(ancestor::" + "bf" + ":data)])/@id";
        try {
            iterator = XPathCache.getInstance().evaluate(elemContext, 1, xpath, this.extendedPrefixMapping, this.xpathFunctionContext).iterator();
        }
        catch (XFormsException e) {
            LOGGER.error((Object)("Error evaluating xpath " + xpath));
        }
        ArrayList<EventTarget> selectList = new ArrayList<EventTarget>();
        ArrayList<EventTarget> deselectList = new ArrayList<EventTarget>();
        while (iterator.hasNext()) {
            String itemId = ((NodeInfo)iterator.next()).getStringValue();
            Item item = (Item)this.container.lookup(itemId);
            if (list.contains(item.getId()) && !item.isSelected()) {
                item.select();
                selectList.add(item.getTarget());
                continue;
            }
            if (list.contains(item.getId()) || !item.isSelected()) continue;
            item.deselect();
            deselectList.add(item.getTarget());
        }
        for (EventTarget evt : deselectList) {
            try {
                this.container.dispatch(evt, "xforms-deselect", null);
            }
            catch (XFormsException e) {
                LOGGER.error((Object)("Error dispatching xforms-deselect  to target " + evt.toString()));
            }
        }
        deselectList.clear();
        for (EventTarget evt : selectList) {
            try {
                this.container.dispatch(evt, "xforms-select", null);
            }
            catch (XFormsException e) {
                LOGGER.error((Object)("Error dispatching xforms-select  to target " + evt.toString()));
            }
        }
        selectList.clear();
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    @Override
    public List getNodeset() {
        try {
            this.updateXPathContext();
        }
        catch (XFormsException e) {
            LOGGER.error((Object)("Could not update XPathContext for Selector " + this.getBindingId()));
        }
        return this.nodeset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setValue(String value) throws XFormsException {
        if (!this.hasBindingExpression()) return;
        String[] values = value.split(" ");
        XFormsElement xfe = null;
        xfe = values.length == 1 ? this.container.lookup(value) : this.container.lookup(values[0]);
        if (xfe != null) {
            if (xfe instanceof Copy) {
                DOMUtil.removeAllChildren((Node)this.model.getInstance(this.getInstanceId()).getModelItem(this.getInstanceNode()).getNode());
                for (int i = 0; i < values.length; ++i) {
                    Copy xfCopy = (Copy)xfe;
                    Node xfCopyInstanceNode = xfCopy.getInstanceNode();
                    Instance instance = this.model.getInstance(this.getInstanceId());
                    Node instanceNode = this.getInstanceNode();
                    if (instanceNode == null || xfCopyInstanceNode == null) throw new XFormsException("error during Selector.setValue: instance: " + instance + " node to copy: " + xfCopyInstanceNode);
                    try {
                        if (xfCopyInstanceNode instanceof Element) {
                            instance.setNode(instanceNode, (Element)xfCopyInstanceNode);
                        } else if (xfCopyInstanceNode instanceof Attr) {
                            instance.insertNode(instanceNode, (Attr)xfCopyInstanceNode, null);
                        }
                    }
                    catch (Exception e) {
                        this.container.dispatch(this.getTarget(), "xforms-binding-exception", null);
                        throw new XFormsBindingException("Node to copy does not exist", e, this.getTarget(), null);
                    }
                    this.dispatchSelectionWithoutValueChange(xfCopyInstanceNode);
                    if (i + 1 >= values.length || (xfe = this.container.lookup(values[i + 1])) instanceof Copy) continue;
                    throw new XFormsException("Control with the id = '" + value + "' is not an xforms:copy");
                }
            } else {
                this.setControlValue(value);
                LOGGER.warn((Object)("Control with the id = '" + value + "' is not an xforms:copy"));
            }
        } else if (this.isMultiple() && this.selectHasCopyChilds) {
            Node instanceNode = this.getInstanceNode();
            DOMUtil.removeAllChildren(instanceNode);
        } else {
            this.setControlValue(value);
        }
        this.dispatchValueChangeSequence();
    }

    private void setControlValue(String value) throws XFormsException {
        this.dispatchSelectionWithoutValueChange(value);
        this.setNodeValue(value);
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        if (this.element.hasAttribute("copySkeleton")) {
            this.copySkeleton = true;
        }
        super.init();
        this.initializeSelection();
    }

    @Override
    public void refresh() throws XFormsException {
        super.refresh();
        this.updateSelection();
    }

    protected void initializeSelection() throws XFormsException {
        if (this.hasBindingExpression()) {
            this.setSelection(true, false, this.getValue());
        }
    }

    protected void updateSelection() throws XFormsException {
        if (this.hasBindingExpression()) {
            this.setSelection(false, false, this.getValue());
        }
    }

    protected void dispatchSelectionWithoutValueChange(Object value) throws XFormsException {
        if (this.hasBindingExpression()) {
            this.setSelection(false, true, value);
        }
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }

    private void setSelection(boolean force, boolean dispatch, Object value) throws XFormsException {
        boolean selectable = true;
        List elemContext = XPathUtil.getElementContext(this.getElement(), this.container.getProcessor().getBaseURI());
        String xfNamespacePrefix = this.xformsPrefix;
        if (xfNamespacePrefix == null) {
            xfNamespacePrefix = "xf";
        }
        String xPath = "(" + xfNamespacePrefix + ":" + "item" + " | *//" + xfNamespacePrefix + ":" + "item" + "[not(ancestor::" + "bf" + ":data)])/@id";
        List items = XPathCache.getInstance().evaluate(elemContext, 1, xPath, this.extendedPrefixMapping, this.xpathFunctionContext);
        Iterator iterator = items.iterator();
        Boolean inRange = false;
        while (iterator.hasNext()) {
            String itemId = ((NodeInfo)iterator.next()).getStringValue();
            Item item = (Item)this.container.lookup(itemId);
            if (item.hasCopyChild()) {
                this.selectHasCopyChilds = true;
            }
            if (selectable && this.isInRange(value, item.getValue())) {
                if (force || !item.isSelected()) {
                    if (this.getLogger().isTraceEnabled()) {
                        this.getLogger().trace((Object)(this + " selecting item " + itemId));
                    }
                    item.select();
                    if (item.hasCopyChild()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("copyItem", "true");
                        map.put("selectedItem", item.getId());
                        this.container.dispatch(this.getTarget(), "betterform-state-changed", map);
                    }
                }
                inRange = true;
                selectable = this.isMultiple();
                continue;
            }
            if (!force && !item.isSelected()) continue;
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace((Object)(this + " deselecting item " + itemId));
            }
            item.deselect();
        }
        if (!inRange.booleanValue()) {
            this.isOutOfRange = true;
            this.container.dispatch(this.target, "xforms-out-of-range", null);
        } else if (this.isOutOfRange) {
            this.isOutOfRange = false;
            this.container.dispatch(this.target, "xforms-in-range", null);
        }
    }

    private boolean isInRange(Object boundValue, Object itemValue) {
        if (boundValue == null || itemValue == null) {
            return false;
        }
        if (boundValue == itemValue) {
            return true;
        }
        if (boundValue instanceof String && itemValue instanceof String) {
            if (this.isMultiple()) {
                String item;
                String bound = " " + (String)boundValue + " ";
                return bound.indexOf(item = " " + (String)itemValue + " ") > -1;
            }
            return boundValue.equals(itemValue);
        }
        if (boundValue instanceof Element && itemValue instanceof Element) {
            DOMComparator domComparator = new DOMComparator();
            if (DOMUtil.hasElementChildren((Element)boundValue)) {
                List boundChildElements = DOMUtil.getChildElements((Element)boundValue);
                for (Element childElement : boundChildElements) {
                    if (!domComparator.compare(childElement, (Element)itemValue)) continue;
                    return true;
                }
            } else if (domComparator.compare((Element)boundValue, (Element)itemValue)) {
                return true;
            }
            if (this.copySkeleton) {
                return this.compareSkeletons((Element)itemValue, (Element)boundValue);
            }
        }
        return false;
    }

    private boolean compareSkeletons(Element itemValue, Element boundValue) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Compare Selector Skeleton itemValue: " + itemValue + " boundValue: " + boundValue));
        }
        DOMComparator comparator = new DOMComparator();
        List boundChildElements = DOMUtil.getChildElements(boundValue);
        for (Element childElement : boundChildElements) {
            if (!comparator.compareSkeleton(itemValue, childElement)) continue;
            return true;
        }
        return false;
    }
}

