/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsBindingException;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.submission.Submission;
import de.betterform.xml.xforms.ui.Trigger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class Submit
extends Trigger
implements EventListener {
    private static final Log LOGGER = LogFactory.getLog(Submit.class);
    private String submissionId = null;

    public Submit(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)(this + " init"));
        }
        this.initializeDefaultAction();
        this.initializeInstanceNode();
        this.updateXPathContext();
        this.initializeSubmit();
        this.initializeElementState();
        this.initializeChildren();
        this.initializeActions();
    }

    @Override
    protected void initializeDefaultAction() {
        super.initializeDefaultAction();
        this.container.getXMLEventService().registerDefaultAction(this.target, "DOMActivate", this);
    }

    @Override
    public void performDefault(Event event) {
        super.performDefault(event);
        if (event.getType().equals("DOMActivate")) {
            try {
                if (this.submissionId != null && this.container.lookup(this.submissionId) != null) {
                    this.container.dispatch(this.submissionId, "xforms-submit", null);
                }
            }
            catch (XFormsException e) {
                this.container.handleEventException(e);
            }
        }
    }

    @Override
    public void dispose() throws XFormsException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)(this + " dispose"));
        }
        this.disposeDefaultAction();
        this.disposeChildren();
        this.disposeElementState();
        this.disposeSubmit();
        this.disposeSelf();
    }

    @Override
    public void setValue(String value) throws XFormsException {
        this.getLogger().warn((Object)(this + " set value: the value of a submit control cannot be set"));
    }

    @Override
    public void handleEvent(Event event) {
    }

    protected final void initializeSubmit() throws XFormsException {
        this.submissionId = this.getXFormsAttribute("submission");
        if (this.submissionId == null) {
            throw new XFormsBindingException("missing submission attribute at " + DOMUtil.getCanonicalPath(this.getElement()), this.target, null);
        }
        XFormsElement submission = this.container.lookup(this.submissionId);
        if (submission != null && submission instanceof Submission) {
            this.target.addEventListener("DOMActivate", this, false);
        }
    }

    protected final void disposeSubmit() {
        this.submissionId = null;
        this.target.removeEventListener("DOMActivate", this, false);
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

