/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.Instance;
import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.model.constraints.Validator;
import de.betterform.xml.xforms.ui.AbstractFormControl;
import de.betterform.xml.xforms.ui.Filename;
import de.betterform.xml.xforms.ui.Mediatype;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class Upload
extends AbstractFormControl {
    private static final Log LOGGER = LogFactory.getLog(Upload.class);
    public static final String DEFAULT_MEDIATYPE = "application/octet-stream";
    private Filename filenameHelper;
    private Mediatype mediatypeHelper;
    private static final String datatypeErrorMsg = "Datatype not supported by this control: ";

    public Upload(Element element, Model model) {
        super(element, model);
    }

    @Override
    public void init() throws XFormsException {
        super.init();
        this.initializeUpload();
    }

    protected final void initializeUpload() throws XFormsException {
        if (this.hasBindingExpression()) {
            String datatype;
            Validator validator = this.model.getValidator();
            if (!(validator.isRestricted("base64Binary", datatype = this.getDatatype()) || validator.isRestricted("hexBinary", datatype) || validator.isRestricted("anyURI", datatype))) {
                this.container.dispatch(this.target, "xforms-binding-exception", (Object)(datatypeErrorMsg + datatype));
                return;
            }
            Instance instance = this.model.getInstance(this.getInstanceId());
            ModelItem item = instance.getModelItem(this.getInstanceNode());
            if (this.filenameHelper != null && !item.isReadonly()) {
                item.setFilename(this.filenameHelper.getValue());
            }
            if (this.mediatypeHelper != null && !item.isReadonly()) {
                item.setMediatype(this.mediatypeHelper.getValue());
            }
        }
    }

    @Override
    public void setValue(String value) throws XFormsException {
        LOGGER.warn((Object)"Update control cannot be set with this method.");
    }

    public void setValue(byte[] data, String filename, String mediatype) throws XFormsException {
        String value;
        if (!this.hasBindingExpression()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("uploading to file: " + filename + " - mediatype: " + mediatype));
        }
        String name = filename;
        String type = mediatype;
        if (data != null && data.length > 0) {
            String datatype;
            Validator validator = this.model.getValidator();
            if (validator.isRestricted("base64Binary", datatype = this.getDatatype())) {
                value = new String(Base64.encodeBase64((byte[])data, (boolean)true));
            } else if (validator.isRestricted("hexBinary", datatype)) {
                value = new String(Hex.encodeHex((byte[])data));
            } else if (validator.isRestricted("anyURI", datatype)) {
                value = new String(data);
            } else {
                this.container.dispatch(this.target, "xforms-binding-exception", (Object)(datatypeErrorMsg + datatype));
                return;
            }
            if (mediatype == null || mediatype.length() == 0) {
                type = DEFAULT_MEDIATYPE;
            }
        } else {
            value = "";
            name = "";
            type = "";
        }
        Instance instance = this.model.getInstance(this.getInstanceId());
        this.setNodeValue(value);
        ModelItem item = this.getModelItem();
        if (!item.isReadonly()) {
            item.setFilename(name);
            item.setMediatype(type);
        }
        if (this.filenameHelper != null) {
            this.filenameHelper.setValue(name);
        }
        if (this.mediatypeHelper != null) {
            this.mediatypeHelper.setValue(type);
        }
        this.dispatchValueChangeSequence();
    }

    public Filename getFilename() {
        return this.filenameHelper;
    }

    public void setFilename(Filename filename) {
        this.filenameHelper = filename;
    }

    public Mediatype getMediatype() {
        return this.mediatypeHelper;
    }

    public void setMediatype(Mediatype mediatype) {
        this.mediatypeHelper = mediatype;
    }

    @Override
    protected Log getLogger() {
        return LOGGER;
    }
}

