/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui.state;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.model.ModelItem;
import de.betterform.xml.xforms.ui.AVTElement;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.UIElementStateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class AVTElementState
implements UIElementState {
    private BindingElement owner;
    private Element state;
    private String currentValue;
    private String allowedAttributes;
    private Map attributeValueMap;

    @Override
    public void setOwner(BindingElement owner) {
        this.owner = owner;
    }

    @Override
    public void init() throws XFormsException {
        String[] attrs;
        this.allowedAttributes = this.owner.getElement().getOwnerDocument().getDocumentElement().getAttributeNS("http://betterform.sourceforge.net/xforms", "evalAVTs");
        for (String attribute : attrs = this.allowedAttributes.split(" ")) {
            if (!this.owner.getElement().hasAttribute(attribute) || this.owner.getElement().getAttribute(attribute).indexOf("{") == -1) continue;
            this.attributeValueMap = new HashMap(attrs.length);
            String expression = this.owner.getElement().getAttribute(attribute);
            this.attributeValueMap.put(attribute, expression);
            String result = ((AVTElement)this.owner).evalAttributeValueTemplates(expression, this.owner.getElement());
            this.owner.getElement().setAttribute(attribute, result.toString());
        }
    }

    @Override
    public void update() throws XFormsException {
        ModelItem modelItem = UIElementStateUtil.getModelItem(this.owner);
        boolean[] properties = UIElementStateUtil.getModelItemProperties(modelItem);
        Container container = this.owner.getContainerObject();
        Set keyset = this.attributeValueMap.keySet();
        for (String attribute : keyset) {
            String result = ((AVTElement)this.owner).evalAttributeValueTemplates((String)this.attributeValueMap.get(attribute), this.owner.getElement());
            this.owner.getElement().setAttribute(attribute, result.toString());
            HashMap<String, String> contextInfo = new HashMap<String, String>(2);
            contextInfo.put("attribute", attribute);
            contextInfo.put("value", result);
            container.dispatch(this.owner.getTarget(), "betterform-AVT-changed", contextInfo);
        }
    }

    @Override
    public void dispose() throws XFormsException {
        DOMUtil.removeAllChildren(this.owner.getElement());
        this.owner = null;
    }

    @Override
    public String getValue() {
        return this.currentValue;
    }

    @Override
    public void setProperty(String name, Object value) {
    }

    @Override
    public Object getSchemaValue() {
        return null;
    }
}

