/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.ui.state;

import de.betterform.xml.config.Config;
import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.ui.BindingElement;
import de.betterform.xml.xforms.ui.Output;
import de.betterform.xml.xforms.ui.UIElementState;
import de.betterform.xml.xforms.ui.state.UIElementStateUtil;
import org.w3c.dom.Element;

public class OutputElementState
implements UIElementState {
    private Output owner;
    private Element state;
    private String currentValue;

    @Override
    public void setOwner(BindingElement owner) {
        this.owner = (Output)owner;
    }

    @Override
    public void init() throws XFormsException {
        Object valueObject;
        this.state = UIElementStateUtil.createStateElement(this.owner.getElement());
        String datatype = UIElementStateUtil.getDefaultDatatype(this.state);
        UIElementStateUtil.setStateAttribute(this.state, "type", datatype);
        if (!this.owner.getModel().isReady() && (valueObject = this.owner.computeValueAttribute()) != null) {
            String value = valueObject.toString();
            UIElementStateUtil.setStateAttribute(this.state, "schema-value", value);
            try {
                value = this.attemptLocalisation(value);
            }
            catch (Exception e) {
                throw new XFormsException("Can't parse value for localisation at: " + DOMUtil.getCanonicalPath(this.owner.getElement()), e);
            }
            DOMUtil.setElementValue(this.state, value);
            this.currentValue = value;
        }
    }

    private String attemptLocalisation(String value) throws Exception {
        if (value != null && Config.getInstance().getProperty("enable.l10n").equals("true")) {
            try {
                Double.parseDouble(value);
                value = UIElementStateUtil.localiseValue(this.owner, this.state, "Double", value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    @Override
    public void update() throws XFormsException {
        Object valueObject = this.owner.computeValueAttribute();
        String value = valueObject != null ? valueObject.toString() : null;
        UIElementStateUtil.setStateAttribute(this.state, "schema-value", value);
        DOMUtil.setElementValue(this.state, value);
        UIElementStateUtil.dispatchBetterFormEvents((BindingElement)this.owner, this.currentValue, value);
        this.currentValue = value;
    }

    @Override
    public void dispose() throws XFormsException {
        this.state.getParentNode().removeChild(this.state);
        this.state = null;
        this.owner = null;
    }

    @Override
    public String getValue() {
        return this.currentValue;
    }

    @Override
    public void setProperty(String name, Object value) {
        UIElementStateUtil.setStateAttribute(this.state, name, (String)value);
    }

    @Override
    public Object getSchemaValue() {
        return UIElementStateUtil.getStateAttribute(this.state, "schema-value");
    }
}

