/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Int64Value;

public class Compare
extends XFormsFunction {
    private static final long serialVersionUID = -8331394395194343808L;

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        String arg1 = this.argument[0].evaluateAsString(xpathContext).toString();
        String arg2 = this.argument[1].evaluateAsString(xpathContext).toString();
        return this.compare(arg1, arg2);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String arg1 = arguments[0].head().getStringValue();
        String arg2 = arguments[1].head().getStringValue();
        return this.compare(arg1, arg2);
    }

    private Int64Value compare(String a, String b) {
        int result = a.compareTo(b);
        if (result < 0) {
            return Int64Value.MINUS_ONE;
        }
        if (result == 0) {
            return Int64Value.ZERO;
        }
        return Int64Value.PLUS_ONE;
    }
}

