/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class DaysFromDate
extends XFormsFunction {
    private static final long serialVersionUID = 7762214764963406284L;

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        CharSequence date = this.argument[0].evaluateAsString(xpathContext);
        return this.daysFromDate(date.toString());
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String date = arguments[0].head().getStringValue();
        return this.daysFromDate(date);
    }

    private NumericValue daysFromDate(String date) {
        CalendarValue argAsValue;
        try {
            argAsValue = (CalendarValue)DateTimeValue.makeDateTimeValue((CharSequence)date, (ConversionRules)new ConversionRules()).asAtomic();
        }
        catch (XPathException e1) {
            try {
                argAsValue = new DateValue((CharSequence)date);
            }
            catch (XPathException e2) {
                return DoubleValue.NaN;
            }
        }
        double days = (double)argAsValue.getCalendar().getTimeInMillis() / 8.64E7;
        return new Int64Value(days > 0.0 ? (long)((int)Math.floor(days)) : (long)((int)Math.ceil(days)));
    }
}

