/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsComputeException;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class Hmac
extends XFormsFunction {
    private static final String kBASE64 = "base64";
    private static final HashSet<String> kSUPPORTED_ALG = new HashSet<String>(Arrays.asList("MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"));
    private static final HashSet<String> kSUPPORTED_ENCODINGS = new HashSet<String>(Arrays.asList("base64", "hex"));
    private static final long serialVersionUID = -8331394395194343808L;

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        String key = this.argument[0].evaluateAsString(xpathContext).toString();
        String data = this.argument[1].evaluateAsString(xpathContext).toString();
        String originalAlgorithmString = this.argument[2].evaluateAsString(xpathContext).toString();
        String encoding = this.argument != null && this.argument.length >= 4 ? this.argument[3].evaluateAsString(xpathContext).toString() : kBASE64;
        return this.hmac(xpathContext, key, data, originalAlgorithmString, encoding);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String key = arguments[0].head().getStringValue();
        String data = arguments[1].head().getStringValue();
        String originalAlgorithmString = arguments[2].head().getStringValue();
        String encoding = arguments.length >= 4 ? arguments[3].head().getStringValue() : kBASE64;
        return this.hmac(context, key, data, originalAlgorithmString, encoding);
    }

    private StringValue hmac(XPathContext context, String key, String data, String originalAlgorithmString, String encoding) throws XPathException {
        if (!kSUPPORTED_ALG.contains(originalAlgorithmString)) {
            XPathFunctionContext functionContext = this.getFunctionContext(context);
            XFormsElement xformsElement = functionContext.getXFormsElement();
            throw new XPathException((Throwable)new XFormsComputeException("Unsupported algorithm '" + originalAlgorithmString + "'", xformsElement.getTarget(), (Object)this));
        }
        if (!kSUPPORTED_ENCODINGS.contains(encoding)) {
            XPathFunctionContext functionContext = this.getFunctionContext(context);
            XFormsElement xformsElement = functionContext.getXFormsElement();
            throw new XPathException((Throwable)new XFormsComputeException("Unsupported encoding '" + encoding + "'", xformsElement.getTarget(), (Object)this));
        }
        String algorithm = "Hmac" + originalAlgorithmString.replaceAll("-", "");
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("utf-8"), algorithm);
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            mac.update(data.getBytes("utf-8"));
            byte[] digest = mac.doFinal();
            Object encoder = kBASE64.equals(encoding) ? new Base64(digest.length, "".getBytes(), false) : new Hex();
            return new StringValue((CharSequence)new String(encoder.encode(digest), "ASCII"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new XPathException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new XPathException((Throwable)e);
        }
        catch (EncoderException e) {
            XPathFunctionContext functionContext = this.getFunctionContext(context);
            XFormsElement xformsElement = functionContext.getXFormsElement();
            throw new XPathException((Throwable)new XFormsComputeException("Encoder exception.", (Exception)((Object)e), xformsElement.getTarget(), (Object)this));
        }
        catch (InvalidKeyException e) {
            throw new XPathException((Throwable)e);
        }
    }
}

