/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.ns.BetterFormNamespaceMap;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.XFormsElement;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.ui.Repeat;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;

public class Index
extends XFormsFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        String idref = this.argument[0].evaluateAsString(xpathContext).toString();
        return this.index(xpathContext, idref);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String idref = arguments[0].head().getStringValue();
        return this.index(context, idref);
    }

    private NumericValue index(XPathContext context, String idref) throws XPathException {
        Container container;
        XPathFunctionContext functionContext = this.getFunctionContext(context);
        if (functionContext != null && (container = functionContext.getXFormsElement().getContainerObject()) != null) {
            List nodeset;
            XFormsElement object = container.lookup(idref);
            if (object != null && object instanceof Repeat) {
                return Int64Value.makeIntegerValue((long)((Repeat)object).getIndex());
            }
            try {
                nodeset = XPathCache.getInstance().evaluate(container.getHostContext("").getNodeset(), 1, "//xf:repeat[@id='" + idref + "'] | //*[@id='" + idref + "'][@" + "xf" + ":repeat-nodeset or @" + "xf" + ":repeat-bind]", BetterFormNamespaceMap.kNAMESPACE_MAP, functionContext);
                String startIndex = XPathCache.getInstance().evaluateAsString(nodeset, 1, "//*[@id='" + idref + "']/@startindex", BetterFormNamespaceMap.kNAMESPACE_MAP, functionContext);
                if (startIndex != null && !container.isModelConstructDone()) {
                    return Int64Value.parseNumber((String)startIndex);
                }
            }
            catch (XFormsException e) {
                throw (XPathException)e.getCause();
            }
            return nodeset.size() == 1 ? Int64Value.makeIntegerValue((long)1L) : DoubleValue.NaN;
        }
        return null;
    }
}

