/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.model.Model;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import java.util.Collections;
import java.util.Optional;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public class Instance
extends XFormsFunction {
    private static final long serialVersionUID = -5302742873313974258L;

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        Optional<String> instanceId;
        if (this.argument.length == 1) {
            Expression instanceIDExpression = this.argument[0];
            instanceId = Optional.ofNullable(instanceIDExpression.evaluateAsString(xpathContext).toString());
        } else {
            instanceId = Optional.empty();
        }
        return this.instance(xpathContext, instanceId);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Optional<String> instanceId = arguments.length == 1 ? Optional.ofNullable(arguments[0].head().getStringValue()) : Optional.empty();
        return SequenceTool.toLazySequence((SequenceIterator)this.instance(context, instanceId));
    }

    private SequenceIterator instance(XPathContext context, Optional<String> instanceId) {
        XPathFunctionContext functionContext = this.getFunctionContext(context);
        if (functionContext != null) {
            Model model = functionContext.getXFormsElement().getModel();
            de.betterform.xml.xforms.model.Instance instance = instanceId.isPresent() ? model.getInstance(instanceId.get()) : model.getDefaultInstance();
            if (instance != null) {
                return new ListIterator(instance.getInstanceNodeset());
            }
        }
        return new ListIterator(Collections.EMPTY_LIST);
    }
}

