/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class SecondsToDateTime
extends XFormsFunction {
    private static final long serialVersionUID = -166224567432883455L;

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        NumericValue secondsAsNumericValue = (NumericValue)this.argument[0].evaluateItem(xpathContext);
        return this.toDateTime(secondsAsNumericValue);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NumericValue secondsAsNumericValue = (NumericValue)arguments[0].head();
        return this.toDateTime(secondsAsNumericValue);
    }

    private StringValue toDateTime(NumericValue secondsAsNumericValue) throws XPathException {
        if (secondsAsNumericValue.isNaN()) {
            return StringValue.EMPTY_STRING;
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.setTime(new Date(secondsAsNumericValue.longValue() * 1000L));
        return new StringValue((CharSequence)new DateTimeValue((Calendar)cal, true).getStringValue());
    }
}

