/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function;

import java.util.HashMap;
import java.util.Map;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;

public abstract class XPathFunctionLibrary
implements FunctionLibrary {
    protected static Sequence EMPTY = EmptySequence.getInstance();
    protected static Map<String, StandardFunction.Entry> functionTable = new HashMap<String, StandardFunction.Entry>(200);
    private static final long serialVersionUID = -6673788638743556161L;

    protected abstract String getFunctionNamespace();

    public Expression bind(SymbolicName symbolicName, Expression[] staticArgs, StaticContext env, Container container) throws XPathException {
        StructuredQName functionName = symbolicName.getComponentName();
        int arity = symbolicName.getArity();
        String uri = functionName.getURI();
        if (uri.equals(this.getFunctionNamespace())) {
            SystemFunctionCall f;
            String local = functionName.getLocalPart();
            StandardFunction.Entry entry = XPathFunctionLibrary.getFunction("{" + uri + "}" + local, arity);
            if (entry == null) {
                if (XPathFunctionLibrary.getFunction("{" + uri + "}" + local, -1) == null) {
                    XPathException err = new XPathException("Unknown function " + local + "()");
                    err.setErrorCode("XPST0017");
                    err.setIsStaticError(true);
                    throw err;
                }
                XPathException err = new XPathException("Function " + local + "() cannot be called with " + XPathFunctionLibrary.pluralArguments(arity));
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            int originalArity = arity;
            if ((entry.properties & 0x40) != 0 && arity == 0) {
                staticArgs = new Expression[]{new ContextItemExpression()};
                arity = 1;
                entry = StandardFunction.getFunction((String)local, (int)arity);
            }
            if ((entry.properties & 0x80) != 0) {
                Expression[] newArgs = new Expression[arity + 1];
                System.arraycopy(staticArgs, 0, newArgs, 0, arity);
                newArgs[arity] = new RootExpression();
                staticArgs = newArgs;
                entry = StandardFunction.getFunction((String)local, (int)(++arity));
            }
            Class functionClass = entry.implementationClass;
            try {
                f = (SystemFunctionCall)functionClass.newInstance();
            }
            catch (Exception err) {
                throw new AssertionError((Object)("Failed to load function {" + uri + "}" + local + " - " + err.getMessage()));
            }
            f.setOriginalArity(originalArity);
            f.setDetails(entry);
            f.setFunctionName(functionName);
            this.checkArgumentCount(arity, entry.minArguments, entry.maxArguments, local);
            if (staticArgs != null) {
                f.setArguments(staticArgs);
            }
            f.setContainer(container);
            f.bindStaticContext(env);
            return f;
        }
        return null;
    }

    public boolean isAvailable(SymbolicName functionName) {
        String uri = functionName.getComponentName().getURI();
        if (uri.equals(this.getFunctionNamespace())) {
            String local = functionName.getComponentName().getLocalPart();
            StandardFunction.Entry entry = XPathFunctionLibrary.getFunction("{" + uri + "}" + local, functionName.getArity());
            return entry != null && (functionName.getArity() == -1 || entry.minArguments <= functionName.getArity() && entry.maxArguments >= functionName.getArity());
        }
        return false;
    }

    private int checkArgumentCount(int numArgs, int min, int max, String local) throws XPathException {
        if (min == max && numArgs != min) {
            throw new XPathException("Function " + local + " must have " + min + XPathFunctionLibrary.pluralArguments(min));
        }
        if (numArgs < min) {
            throw new XPathException("Function " + local + " must have at least " + min + XPathFunctionLibrary.pluralArguments(min));
        }
        if (numArgs > max) {
            throw new XPathException("Function " + local + " must have  no more than " + max + XPathFunctionLibrary.pluralArguments(max));
        }
        return numArgs;
    }

    private static String pluralArguments(int num) {
        if (num == 0) {
            return "zero arguments";
        }
        if (num == 1) {
            return "one argument";
        }
        return num + " arguments";
    }

    public FunctionLibrary copy() {
        return this;
    }

    public static StandardFunction.Entry getFunction(String name, int arity) {
        if (arity == -1) {
            for (int i = 0; i < 10; ++i) {
                StandardFunction.Entry e = XPathFunctionLibrary.getFunction(name, i);
                if (e == null) continue;
                return e;
            }
            return null;
        }
        StandardFunction.Entry e = functionTable.get(name + '#' + arity);
        if (e != null) {
            return e;
        }
        return functionTable.get(name);
    }
}

