/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.extensions;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class BFSort
extends XFormsFunction {
    private static final long serialVersionUID = -5525518237429365423L;

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        SequenceIterator nodeset = this.argument[0].iterate(xpathContext);
        Expression sortByKey = this.argument[1];
        return this.sortnodes(xpathContext, nodeset, sortByKey);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator nodeset = arguments[0].iterate();
        final Item sortByKey = arguments[0].head();
        SortKeyEvaluator ske = new SortKeyEvaluator(){

            public AtomicValue evaluateSortKey(int n, XPathContext context) throws XPathException {
                return new StringValue((CharSequence)sortByKey.getStringValue());
            }
        };
        AtomicComparer[] comparers = new AtomicComparer[]{AtomicSortComparer.makeSortComparer(null, (int)88, (XPathContext)context)};
        return SequenceTool.toLazySequence((SequenceIterator)new SortedIterator(context, nodeset, ske, comparers, true));
    }

    protected SequenceIterator sortnodes(XPathContext xpathContext, SequenceIterator nodeset, final Expression sortByKey) throws XPathException {
        SortKeyEvaluator ske = new SortKeyEvaluator(){

            public AtomicValue evaluateSortKey(int i, XPathContext context) throws XPathException {
                Item item = sortByKey.evaluateItem(context);
                AtomicValue value = item instanceof NodeInfo ? ((NodeInfo)item).atomize().itemAt(i) : null;
                return value;
            }
        };
        SortKeyDefinition skd = new SortKeyDefinition(this.getContainer());
        skd.setSortKey(sortByKey, true);
        AtomicComparer[] comparers = new AtomicComparer[]{skd.makeComparator(xpathContext)};
        return new SortedIterator(xpathContext, nodeset, ske, comparers, true);
    }
}

