/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class Aggregate2
extends SystemFunctionCall {
    public static final int SUM = 0;
    public static final int AVG = 1;
    public static final int COUNT = 4;

    public ItemType getItemType() {
        switch (this.operation) {
            case 4: {
                return super.getItemType();
            }
            case 0: {
                ItemType base = Atomizer.getAtomizedItemType((Expression)this.argument[0], (boolean)false, null);
                if (base.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    base = BuiltInAtomicType.DOUBLE;
                }
                if (Cardinality.allowsZero((int)this.argument[0].getCardinality())) {
                    if (this.argument.length == 1) {
                        return Type.getCommonSuperType((ItemType)base, (ItemType)BuiltInAtomicType.INTEGER);
                    }
                    return Type.getCommonSuperType((ItemType)base, (ItemType)this.argument[1].getItemType());
                }
                return base;
            }
            case 1: {
                ItemType base = Atomizer.getAtomizedItemType((Expression)this.argument[0], (boolean)false, null);
                if (base.equals(BuiltInAtomicType.UNTYPED_ATOMIC)) {
                    return BuiltInAtomicType.DOUBLE;
                }
                if (base.getPrimitiveType() == 533) {
                    return BuiltInAtomicType.DECIMAL;
                }
                return base;
            }
        }
        throw new AssertionError((Object)"Unknown aggregate operation");
    }

    public int computeCardinality() {
        if (this.operation == 1 && !Cardinality.allowsZero((int)this.argument[0].getCardinality())) {
            return 16384;
        }
        return super.computeCardinality();
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        switch (this.operation) {
            case 4: {
                SequenceIterator iter = this.argument[0].iterate(context);
                return new Int64Value((long)Aggregate2.count(iter));
            }
            case 0: {
                AtomicValue sum = Aggregate2.total(this.argument[0].iterate(context), context, (SourceLocator)((Object)this));
                if (sum != null) {
                    return sum;
                }
                if (this.argument.length == 2) {
                    return (AtomicValue)this.argument[1].evaluateItem(context);
                }
                return Int64Value.ZERO;
            }
            case 1: {
                return Aggregate2.average(this.argument[0].iterate(context), context, (SourceLocator)((Object)this));
            }
        }
        throw new UnsupportedOperationException("Unknown aggregate function");
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        switch (this.operation) {
            case 4: {
                SequenceIterator iter = arguments[0].iterate();
                return new Int64Value((long)Aggregate2.count(iter));
            }
            case 0: {
                AtomicValue sum = Aggregate2.total(arguments[0].iterate(), context, (SourceLocator)((Object)this));
                if (sum != null) {
                    return sum;
                }
                if (this.argument.length == 2) {
                    return arguments[1].head();
                }
                return Int64Value.ZERO;
            }
            case 1: {
                return Aggregate2.average(arguments[0].iterate(), context, (SourceLocator)((Object)this));
            }
        }
        throw new UnsupportedOperationException("Unknown aggregate function");
    }

    public static AtomicValue total(SequenceIterator iter, XPathContext context, SourceLocator location) throws XPathException {
        AtomicValue sum = (AtomicValue)iter.next();
        if (sum == null) {
            return DoubleValue.NaN;
        }
        if (sum instanceof UntypedAtomicValue) {
            sum = Aggregate2.convertToDouble(sum);
        }
        if (sum instanceof NumericValue) {
            AtomicValue next;
            while ((next = (AtomicValue)iter.next()) != null) {
                if (!(next instanceof UntypedAtomicValue)) {
                    return DoubleValue.NaN;
                }
                next = Aggregate2.convertToDouble(next);
                if (!((NumericValue)(sum = ArithmeticExpression.compute((AtomicValue)sum, (int)0, (AtomicValue)((NumericValue)next), (XPathContext)context))).isNaN()) continue;
                return sum;
            }
            return sum;
        }
        if (sum instanceof DurationValue) {
            AtomicValue next;
            while ((next = (AtomicValue)iter.next()) != null) {
                if (!(next instanceof DurationValue)) {
                    return DoubleValue.NaN;
                }
                sum = ((DurationValue)sum).add((DurationValue)next);
            }
            return sum;
        }
        return DoubleValue.NaN;
    }

    private static DoubleValue convertToDouble(AtomicValue atomicValue) {
        try {
            String value = atomicValue.getStringValue();
            return new DoubleValue(Double.valueOf(value).doubleValue(), (AtomicType)BuiltInAtomicType.DOUBLE);
        }
        catch (NumberFormatException nfe) {
            return DoubleValue.NaN;
        }
    }

    public static AtomicValue average(SequenceIterator iter, XPathContext context, SourceLocator location) throws XPathException {
        int count = 0;
        AtomicValue item = (AtomicValue)iter.next();
        if (item == null) {
            return DoubleValue.NaN;
        }
        ++count;
        if (item instanceof UntypedAtomicValue) {
            try {
                item = Aggregate2.convertToDouble(item);
            }
            catch (NumberFormatException nfe) {
                return DoubleValue.NaN;
            }
        }
        if (item instanceof NumericValue) {
            AtomicValue next;
            do {
                if ((next = (AtomicValue)iter.next()) == null) {
                    return ArithmeticExpression.compute((AtomicValue)item, (int)3, (AtomicValue)new Int64Value((long)count), (XPathContext)context);
                }
                ++count;
                if (next instanceof UntypedAtomicValue) {
                    try {
                        next = Aggregate2.convertToDouble(next);
                    }
                    catch (NumberFormatException nfe) {
                        return DoubleValue.NaN;
                    }
                } else {
                    if (next instanceof NumericValue) continue;
                    return DoubleValue.NaN;
                }
            } while (!((NumericValue)(item = ArithmeticExpression.compute((AtomicValue)item, (int)0, (AtomicValue)((NumericValue)next), (XPathContext)context))).isNaN());
            return item;
        }
        if (item instanceof DurationValue) {
            while (true) {
                AtomicValue next;
                if ((next = (AtomicValue)iter.next()) == null) {
                    return ((DurationValue)item).multiply(1.0 / (double)count);
                }
                ++count;
                if (!(next instanceof DurationValue)) {
                    return DoubleValue.NaN;
                }
                item = ((DurationValue)item).add((DurationValue)next);
            }
        }
        return DoubleValue.NaN;
    }

    public static int count(SequenceIterator iter) throws XPathException {
        if ((iter.getProperties() & 2) != 0) {
            return ((LastPositionFinder)iter).getLength();
        }
        int n = 0;
        while (iter.next() != null) {
            ++n;
        }
        return n;
    }
}

