/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import org.apache.commons.net.util.SubnetUtils;

public class CalcIPRange
extends XFormsFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        if (this.argument.length != 2) {
            throw new XPathException("There must be 2 arguments (ip address, subnetmask) for this function");
        }
        Expression subnetIDExpression = this.argument[0];
        String subnetID = subnetIDExpression.evaluateAsString(xpathContext).toString();
        Expression subnetMaskExpression = this.argument[1];
        String subnetMask = subnetMaskExpression.evaluateAsString(xpathContext).toString();
        return this.ipRange(subnetID, subnetMask);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String subnetID = arguments[0].head().getStringValue();
        String subnetMask = arguments[1].head().getStringValue();
        return this.ipRange(subnetID, subnetMask);
    }

    private StringValue ipRange(String subnetID, String subnetMask) {
        if ("".equals(subnetID.trim()) || "".equals(subnetMask.trim())) {
            return new StringValue((CharSequence)"unknown");
        }
        SubnetUtils subnetUtils = new SubnetUtils(subnetID, subnetMask);
        return new StringValue((CharSequence)(subnetUtils.getInfo().getLowAddress() + " - " + subnetUtils.getInfo().getHighAddress()));
    }
}

