/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.Collections;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CreateAttributeNode
extends XFormsFunction {
    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        if (this.argument.length != 2) {
            throw new XPathException("There must be 2 arguments (attributeName, attributeValue) for this function");
        }
        Expression attributeNameExpression = this.argument[0];
        String attributeName = attributeNameExpression.evaluateAsString(xpathContext).toString();
        Expression attributeValueExpression = this.argument[1];
        String attributeValue = attributeValueExpression.evaluateAsString(xpathContext).toString();
        return this.createAttribute(xpathContext, attributeName, attributeValue);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String attributeName = arguments[0].head().getStringValue();
        String attributeValue = arguments[1].head().getStringValue();
        return SequenceTool.toLazySequence((SequenceIterator)this.createAttribute(context, attributeName, attributeValue));
    }

    private SequenceIterator createAttribute(XPathContext context, String name, String value) {
        XPathFunctionContext functionContext = this.getFunctionContext(context);
        if (functionContext != null) {
            Document document = DOMUtil.newDocument(false, false);
            Element attributeNode = document.createElement("attributeNode");
            document.appendChild(attributeNode);
            attributeNode.setAttribute(name, value);
            return new ListIterator(XPathUtil.getRootContext(document, ""));
        }
        return new ListIterator(Collections.EMPTY_LIST);
    }
}

