/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileDate
extends XFormsFunction {
    private static final Log LOGGER = LogFactory.getLog(FileDate.class);

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        String format;
        if (this.argument.length < 1 || this.argument.length > 2) {
            throw new XPathException("There must be 1 argument (filename)  or 2 arguments (filename, format) for this function");
        }
        Expression filenameExpression = this.argument[0];
        String filename = filenameExpression.evaluateAsString(xpathContext).toString();
        if (this.argument.length == 2) {
            Expression formatExpression = this.argument[1];
            format = formatExpression.evaluateAsString(xpathContext).toString();
        } else {
            format = null;
        }
        return this.fileDate(xpathContext, filename, format);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String filename = arguments[0].head().getStringValue();
        String format = arguments.length == 2 ? arguments[1].head().getStringValue() : null;
        return this.fileDate(context, filename, format);
    }

    private Item fileDate(XPathContext c, String filename, String format) {
        if (filename == null) {
            return null;
        }
        try {
            return new StringValue((CharSequence)this.formatDateString(new URI(this.getContainer(c).getProcessor().getBaseURI()).resolve(filename).toURL().openConnection().getLastModified(), format));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to retrieve change data.", (Throwable)e);
            return null;
        }
    }

    private String formatDateString(long modified, String format) {
        GregorianCalendar calendar = new GregorianCalendar(Locale.getDefault());
        calendar.setTimeInMillis(modified);
        SimpleDateFormat simple = null;
        if (format == null || format.equals("")) {
            simple = new SimpleDateFormat("dd.MM.yyyy H:m:s");
        } else {
            try {
                simple = new SimpleDateFormat(format);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        String result = simple.format(calendar.getTime());
        return result;
    }
}

