/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import java.net.URI;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.FloatValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileSize
extends XFormsFunction {
    private static final Log LOGGER = LogFactory.getLog(FileSize.class);

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        if (this.argument.length != 1) {
            throw new XPathException("There must be 1 argument (filename) for this function");
        }
        Expression keyExpression = this.argument[0];
        String filename = keyExpression.evaluateAsString(xpathContext).toString();
        return this.fileSize(xpathContext, filename);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String filename = arguments[0].head().getStringValue();
        return this.fileSize(context, filename);
    }

    private FloatValue fileSize(XPathContext context, String filename) {
        if (filename == null) {
            return new FloatValue(Float.NaN);
        }
        try {
            Container container = this.getContainer(context);
            return new FloatValue((float)new URI(container.getProcessor().getBaseURI()).resolve(filename).toURL().openConnection().getContentLength());
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to retrieve file size", (Throwable)e);
            return new FloatValue(Float.NaN);
        }
    }
}

