/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;

public class Match
extends XFormsFunction {
    private static Map m_regexPatterns = new HashMap();

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public Item evaluateItem(XPathContext xpathContext) throws XPathException {
        String flags;
        if (this.argument.length < 2 || this.argument.length > 3) {
            throw new XPathException("There must be 2 arguments (input, regex) or 3 (input, regex, flags) arguments for this function");
        }
        Expression inputExpression = this.argument[0];
        String input = inputExpression.evaluateAsString(xpathContext).toString();
        Expression regexExpression = this.argument[1];
        String regex = regexExpression.evaluateAsString(xpathContext).toString();
        if (this.argument.length == 3) {
            Expression flagsExpression = this.argument[2];
            flags = flagsExpression.evaluateAsString(xpathContext).toString();
        } else {
            flags = null;
        }
        return BooleanValue.get((boolean)this.match(input, regex, flags));
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String input = arguments[0].head().getStringValue();
        String regex = arguments[1].head().getStringValue();
        String flags = arguments.length == 3 ? arguments[2].head().getStringValue() : null;
        return BooleanValue.get((boolean)this.match(input, regex, flags));
    }

    public boolean match(String input, String regex, String flags) {
        String regexKey = flags == null || flags.indexOf(105) == -1 ? "s " + regex : "i " + regex;
        Pattern pattern = (Pattern)m_regexPatterns.get(regexKey);
        if (pattern == null) {
            pattern = regexKey.charAt(0) == 'i' ? Pattern.compile(regex, 2) : Pattern.compile(regex);
            m_regexPatterns.put(regexKey, pattern);
        }
        Matcher matcher = pattern.matcher(input);
        return matcher.matches();
    }
}

