/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaElement
extends XFormsFunction {
    private static final Log LOGGER = LogFactory.getLog(SchemaElement.class);

    private XSTypeDefinition getTypeDefinition(XSModel schemaModel, String name, String namespace) {
        XSNamedMap map = schemaModel.getComponents((short)3);
        for (int j = 0; j < map.getLength(); ++j) {
            XSTypeDefinition xsTypeDefinition = (XSTypeDefinition)map.item(j);
            if (!xsTypeDefinition.getName().equals(name)) continue;
            if (namespace == null) {
                return xsTypeDefinition;
            }
            if (!xsTypeDefinition.getNamespace().equals(namespace)) continue;
            return xsTypeDefinition;
        }
        return null;
    }

    private Document getContextNode(String namespace, String elementName, String parent, XSModel xsModel) {
        try {
            ListIterator xsNamespaceItemList = xsModel.getNamespaceItems().listIterator();
            while (xsNamespaceItemList.hasNext()) {
                String schemaNamespace = ((XSNamespaceItem)xsNamespaceItemList.next()).getSchemaNamespace();
                if (!namespace.equals(schemaNamespace)) continue;
                if (parent != null) {
                    XSObject xsObject = this.findChild(namespace, elementName, parent, xsModel);
                    if (xsObject == null) continue;
                    if (xsObject instanceof XSElementDeclaration) {
                        return this.handleElement((XSElementDeclaration)xsObject);
                    }
                    if (!(xsObject instanceof XSModelGroupDefinition)) continue;
                    return this.handleModelGroup((XSModelGroupDefinition)xsObject);
                }
                XSElementDeclaration xsElementDeclaration = xsModel.getElementDeclaration(elementName, namespace);
                if (xsElementDeclaration != null) {
                    return this.handleElement(xsElementDeclaration);
                }
                XSModelGroupDefinition xsModelGroupDefinition = xsModel.getModelGroupDefinition(elementName, namespace);
                if (xsModelGroupDefinition == null) continue;
                return this.handleModelGroup(xsModelGroupDefinition);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private XSObject findChild(String namespace, String elementName, String parent, XSModel xsModel) {
        XSModelGroupDefinition xsModelGroupDefinition;
        XSTypeDefinition xsTypeDefinition;
        XSElementDeclaration xsElementDeclaration = xsModel.getElementDeclaration(parent, namespace);
        if (xsElementDeclaration != null && (xsTypeDefinition = xsElementDeclaration.getTypeDefinition()) != null) {
            if (xsTypeDefinition instanceof XSComplexTypeDefinition) {
                XSComplexTypeDefinition xsComplexTypeDefinition = (XSComplexTypeDefinition)xsTypeDefinition;
                return this.searchComplextype(xsComplexTypeDefinition, elementName);
            }
            if (xsTypeDefinition instanceof XSComplexTypeDecl || xsTypeDefinition instanceof XSSimpleTypeDefinition) {
                // empty if block
            }
        }
        if ((xsModelGroupDefinition = xsModel.getModelGroupDefinition(parent, namespace)) != null) {
            return this.searchModelChild(xsModelGroupDefinition, elementName);
        }
        return null;
    }

    private XSObject searchComplextype(XSComplexTypeDefinition xsComplexTypeDefinition, String elementName) {
        XSTerm term;
        if (xsComplexTypeDefinition.getParticle() != null && (term = xsComplexTypeDefinition.getParticle().getTerm()) instanceof XSModelGroup) {
            XSObjectList particles = ((XSModelGroup)term).getParticles();
            block5: for (int j = 0; j < particles.getLength(); ++j) {
                XSParticle particle = (XSParticle)particles.item(j);
                XSTerm particleTerm = particle.getTerm();
                if (particleTerm instanceof XSElementDeclaration) {
                    XSElementDeclaration xsElementDeclaration = (XSElementDeclaration)particleTerm;
                    if (!elementName.equals(xsElementDeclaration.getName())) continue;
                    return xsElementDeclaration;
                }
                if (!(particleTerm instanceof XSModelGroup)) continue;
                XSModelGroup group = (XSModelGroup)particleTerm;
                switch (group.getCompositor()) {
                    case 1: {
                        XSObjectList groupParticles = group.getParticles();
                        for (int z = 0; z < groupParticles.getLength(); ++z) {
                            XSParticle groupParticle = (XSParticle)groupParticles.item(z);
                            XSTerm groupParticleTerm = groupParticle.getTerm();
                            if (!elementName.equals(groupParticleTerm.getName())) continue;
                            return groupParticleTerm;
                        }
                        continue block5;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 3: {
                        continue block5;
                    }
                    default: {
                        LOGGER.warn((Object)("SchemaReader: unknown Compositor in schema: " + ((XSModelGroup)term).getCompositor()));
                    }
                }
            }
        }
        return null;
    }

    private XSObject searchModelChild(XSModelGroupDefinition xsModelGroupDefinition, String elementName) {
        for (Object object : xsModelGroupDefinition.getModelGroup().getParticles()) {
            XSTerm xsObject = ((XSParticleDecl)object).getTerm();
            if (!elementName.equals(xsObject.getName())) continue;
            return xsObject;
        }
        return null;
    }

    private Document handleElement(XSElementDeclaration xsElementDeclaration) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        Document document = factory.newDocumentBuilder().newDocument();
        document.appendChild(document.createElementNS(xsElementDeclaration.getNamespace(), xsElementDeclaration.getName()));
        Element rootElement = document.getDocumentElement();
        XSTypeDefinition xsTypeDefinition = xsElementDeclaration.getTypeDefinition();
        if (xsTypeDefinition != null) {
            if (xsTypeDefinition instanceof XSComplexTypeDefinition) {
                this.handleComplexType((XSComplexTypeDefinition)xsTypeDefinition, document, rootElement);
            } else if (xsTypeDefinition instanceof XSComplexTypeDecl || xsTypeDefinition instanceof XSSimpleTypeDefinition) {
                // empty if block
            }
        }
        return document;
    }

    private void handleComplexType(XSComplexTypeDefinition xsComplexTypeDefinition, Document document, Element rootElement) {
        for (Object object : xsComplexTypeDefinition.getAttributeUses()) {
            XSAttributeUse xsAttributeUse = (XSAttributeUse)object;
            rootElement.setAttributeNS(xsAttributeUse.getAttrDeclaration().getNamespace(), xsAttributeUse.getAttrDeclaration().getName(), "");
        }
    }

    private Document handleModelGroup(XSModelGroupDefinition xsModelGroupDefinition) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        Document document = factory.newDocumentBuilder().newDocument();
        document.appendChild(document.createElementNS(xsModelGroupDefinition.getNamespace(), xsModelGroupDefinition.getName()));
        Element rootElement = document.getDocumentElement();
        for (Object object : xsModelGroupDefinition.getModelGroup().getParticles()) {
            XSObject xsObject = (XSObject)object;
            System.out.println(xsObject.getNamespace() + "," + xsObject.getName());
        }
        return document;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        String namespace = null;
        if (this.argument[0] != null) {
            namespace = this.argument[0].evaluateAsString(xpathContext).toString();
        }
        String elementName = this.argument[1].evaluateAsString(xpathContext).toString();
        String parent = null;
        if (this.argument.length >= 3 && this.argument[2] != null) {
            parent = this.argument[2].evaluateAsString(xpathContext).toString();
        }
        return this.schemaElement(xpathContext, namespace, elementName, parent);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String namespace = null;
        if (arguments[0].head() != null) {
            namespace = arguments[0].head().getStringValue();
        }
        String elementName = arguments[1].head().getStringValue();
        String parent = null;
        if (arguments.length >= 3 && arguments[2].head() != null) {
            parent = arguments[2].head().getStringValue();
        }
        return SequenceTool.toLazySequence((SequenceIterator)this.schemaElement(context, namespace, elementName, parent));
    }

    private net.sf.saxon.tree.iter.ListIterator schemaElement(XPathContext context, String namespace, String elementName, String parent) throws XPathException {
        try {
            Container container = this.getContainer(context);
            if (container != null) {
                List schemas = container.getDefaultModel().getSchemas();
                for (XSModel xsModel : schemas) {
                    Document elementDocument = this.getContextNode(namespace, elementName, parent, xsModel);
                    if (LOGGER.isDebugEnabled() && elementDocument != null) {
                        DOMUtil.prettyPrintDOM(elementDocument.getDocumentElement());
                    }
                    if (elementDocument == null) continue;
                    String baseURI = container.getProcessor().getBaseURI();
                    return new net.sf.saxon.tree.iter.ListIterator(XPathUtil.getRootContext(elementDocument, baseURI));
                }
            }
            return new net.sf.saxon.tree.iter.ListIterator(Collections.EMPTY_LIST);
        }
        catch (Exception e) {
            throw new XPathException((Throwable)e);
        }
    }
}

