/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xforms.xpath.saxon.function.xpath;

import de.betterform.xml.dom.DOMUtil;
import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunction;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNamespaceItem;
import org.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaEnumeration
extends XFormsFunction {
    private static final Log LOGGER = LogFactory.getLog(SchemaEnumeration.class);

    private XSTypeDefinition getTypeDefinition(XSModel schemaModel, String name, String namespace) {
        XSNamedMap map = schemaModel.getComponents((short)3);
        for (int j = 0; j < map.getLength(); ++j) {
            XSTypeDefinition xsTypeDefinition = (XSTypeDefinition)map.item(j);
            if (!xsTypeDefinition.getName().equals(name)) continue;
            if (namespace == null) {
                return xsTypeDefinition;
            }
            if (!xsTypeDefinition.getNamespace().equals(namespace)) continue;
            return xsTypeDefinition;
        }
        return null;
    }

    private Document getContextNode(String namespace, String elementName, XSModel xsModel) {
        try {
            ListIterator xsNamespaceItemList = xsModel.getNamespaceItems().listIterator();
            while (xsNamespaceItemList.hasNext()) {
                XSSimpleTypeDecl xsSimpleTypeDecl;
                StringList lexicalEnumeration;
                XSTypeDefinition xsTypeDefinition;
                String schemaNamespace = ((XSNamespaceItem)xsNamespaceItemList.next()).getSchemaNamespace();
                if (!namespace.equals(schemaNamespace) || (xsTypeDefinition = xsModel.getTypeDefinition(elementName, namespace)) == null) continue;
                LOGGER.debug((Object)"Do something.");
                if (!(xsTypeDefinition instanceof XSSimpleTypeDecl) || (lexicalEnumeration = (xsSimpleTypeDecl = (XSSimpleTypeDecl)xsTypeDefinition).getLexicalEnumeration()).getLength() <= 0) continue;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                factory.setValidating(false);
                Document document = factory.newDocumentBuilder().newDocument();
                document.appendChild(document.createElementNS(namespace, elementName));
                Element rootElement = document.getDocumentElement();
                for (int i = 0; i < lexicalEnumeration.getLength(); ++i) {
                    Element childElement = document.createElementNS(namespace, lexicalEnumeration.item(i));
                    childElement.setTextContent(lexicalEnumeration.item(i));
                    rootElement.appendChild(childElement);
                }
                return document;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) throws XPathException {
        return this;
    }

    public SequenceIterator iterate(XPathContext xpathContext) throws XPathException {
        String namespace = this.argument[0].evaluateAsString(xpathContext).toString();
        String elementName = this.argument[1].evaluateAsString(xpathContext).toString();
        return this.schemaEnumeration(xpathContext, namespace, elementName);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String namespace = arguments[0].head().getStringValue();
        String elementName = arguments[1].head().getStringValue();
        return SequenceTool.toLazySequence((SequenceIterator)this.schemaEnumeration(context, namespace, elementName));
    }

    private SequenceIterator schemaEnumeration(XPathContext context, String namespace, String elementName) throws XPathException {
        Container container = this.getContainer(context);
        if (container != null) {
            try {
                List schemas = container.getDefaultModel().getSchemas();
                for (XSModel xsModel : schemas) {
                    Document elementDocument = this.getContextNode(namespace, elementName, xsModel);
                    if (LOGGER.isDebugEnabled() && elementDocument != null) {
                        DOMUtil.prettyPrintDOM(elementDocument.getDocumentElement());
                    }
                    if (elementDocument == null) continue;
                    String baseURI = container.getProcessor().getBaseURI();
                    return new net.sf.saxon.tree.iter.ListIterator(XPathUtil.getRootContext(elementDocument, baseURI));
                }
            }
            catch (Exception e) {
                throw new XPathException((Throwable)e);
            }
        }
        return new net.sf.saxon.tree.iter.ListIterator(Collections.EMPTY_LIST);
    }
}

