/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xpath.impl.saxon;

import de.betterform.xml.xforms.Container;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.xpath.saxon.function.Instance;
import de.betterform.xml.xpath.XPathReferenceFinder;
import de.betterform.xml.xpath.impl.saxon.SaxonXPathExpressionSerializer;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.pattern.NodeKindTest;

public class SaxonReferenceFinderImpl
implements XPathReferenceFinder {
    @Override
    public Set<String> getReferences(String xpath, Map prefixMapping, Container container) throws XFormsException {
        try {
            Expression expression = XPathCache.getInstance().getXPathExpression(xpath, prefixMapping, container.getConfiguration()).getInternalExpression();
            HashSet<String> references = new HashSet<String>();
            this.addExpressionReferences(references, null, expression, prefixMapping);
            return references;
        }
        catch (Exception e) {
            throw new XFormsException("Can't resolve references for: " + xpath + " (" + e.getMessage() + ")", e);
        }
    }

    private void addExpressionReferences(Set<String> references, String context, Expression expression, Map prefixMapping) {
        block8: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block7: {
                                            if (!(expression instanceof AxisExpression) || ((AxisExpression)expression).getAxis() != 9 || ((AxisExpression)expression).getNodeTest() instanceof NodeKindTest && ((NodeKindTest)((AxisExpression)expression).getNodeTest()).getNodeKind() == 1) break block7;
                                            references.add(context != null ? context + "/.." : "..");
                                            break block8;
                                        }
                                        if (!(expression instanceof AxisExpression)) break block9;
                                        references.add((context != null ? context + "/" : "") + SaxonXPathExpressionSerializer.serialize(expression, prefixMapping));
                                        break block8;
                                    }
                                    if (!(expression instanceof SimpleStepExpression) || !(((SimpleStepExpression)expression).getSelectExpression() instanceof ItemChecker) || !(((ItemChecker)((SimpleStepExpression)expression).getSelectExpression()).getBaseExpression() instanceof ContextItemExpression)) break block10;
                                    SimpleStepExpression simpleStepExpression = (SimpleStepExpression)expression;
                                    Expression rhsExpression = simpleStepExpression.getActionExpression();
                                    this.addExpressionReferences(references, context, rhsExpression, prefixMapping);
                                    break block8;
                                }
                                if (!(expression instanceof SlashExpression)) break block11;
                                SlashExpression slashExpression = (SlashExpression)expression;
                                Expression lhsExpression = slashExpression.getSelectExpression();
                                Expression rhsExpression = slashExpression.getActionExpression();
                                if (lhsExpression instanceof SimpleStepExpression && ((SimpleStepExpression)lhsExpression).getSelectExpression() instanceof ItemChecker && ((ItemChecker)((SimpleStepExpression)lhsExpression).getSelectExpression()).getBaseExpression() instanceof ContextItemExpression) {
                                    Expression lhsExpressionAction = ((SimpleStepExpression)lhsExpression).getActionExpression();
                                    this.addExpressionReferences(references, context, lhsExpressionAction, prefixMapping);
                                    String newContext = SaxonXPathExpressionSerializer.serialize(lhsExpressionAction, prefixMapping);
                                    this.addExpressionReferences(references, newContext, rhsExpression, prefixMapping);
                                } else {
                                    this.addExpressionReferences(references, context, lhsExpression, prefixMapping);
                                    String newContext = SaxonXPathExpressionSerializer.serialize(lhsExpression, prefixMapping);
                                    this.addExpressionReferences(references, newContext, rhsExpression, prefixMapping);
                                }
                                break block8;
                            }
                            if (!(expression instanceof FilterExpression)) break block12;
                            FilterExpression filterExpression = (FilterExpression)expression;
                            Expression lhsExpression = filterExpression.getSelectExpression();
                            Expression rhsExpression = filterExpression.getActionExpression();
                            if (lhsExpression instanceof SimpleStepExpression && ((SimpleStepExpression)lhsExpression).getSelectExpression() instanceof ItemChecker && ((ItemChecker)((SimpleStepExpression)lhsExpression).getSelectExpression()).getBaseExpression() instanceof ContextItemExpression) {
                                Expression lhsExpressionAction = ((SimpleStepExpression)lhsExpression).getActionExpression();
                                this.addExpressionReferences(references, context, lhsExpressionAction, prefixMapping);
                                String newContext = SaxonXPathExpressionSerializer.serialize(lhsExpressionAction, prefixMapping);
                                this.addExpressionReferences(references, newContext, rhsExpression, prefixMapping);
                            } else {
                                this.addExpressionReferences(references, context, lhsExpression, prefixMapping);
                                String newContext = SaxonXPathExpressionSerializer.serialize(lhsExpression, prefixMapping);
                                this.addExpressionReferences(references, newContext, rhsExpression, prefixMapping);
                            }
                            break block8;
                        }
                        if (!(expression instanceof FunctionCall)) break block13;
                        String newContext = SaxonXPathExpressionSerializer.serialize(expression, prefixMapping);
                        if (expression instanceof Instance) {
                            references.add(newContext);
                        }
                        for (Operand o : expression.operands()) {
                            this.addExpressionReferences(references, context, o.getExpression(), prefixMapping);
                        }
                        break block8;
                    }
                    if (!(expression instanceof ContextItemExpression)) break block14;
                    references.add(context != null ? context : ".");
                    break block8;
                }
                if (!(expression instanceof Assignation)) break block15;
                Assignation a = (Assignation)expression;
                this.addExpressionReferences(references, context, a.getSequence(), prefixMapping);
                if (null == a.getAction()) break block8;
                this.addExpressionReferences(references, context, a.getAction(), prefixMapping);
                break block8;
            }
            for (Operand o : expression.operands()) {
                this.addExpressionReferences(references, context, o.getExpression(), prefixMapping);
            }
        }
    }
}

