/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xpath.impl.saxon;

import de.betterform.xml.xforms.XFormsProcessorImpl;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.xpath.saxon.function.BetterFormFunctionLibrary;
import de.betterform.xml.xforms.xpath.saxon.function.XFormsFunctionLibrary;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import de.betterform.xml.xpath.impl.saxon.BetterFormXPathContext;
import de.betterform.xml.xpath.impl.saxon.XPathUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathStaticContext;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.xpath.XPathFunctionLibrary;
import org.w3c.dom.Node;

public class XPathCache {
    private static final Configuration kCONFIG = new Configuration();
    private static final FunctionLibraryList fgXFormsFunctionLibrary;
    private static final XPathCache fgXPathCache;

    public static XPathCache getInstance() {
        return fgXPathCache;
    }

    private XPathCache() {
    }

    public static FunctionLibraryList getFgXFormsFunctionLibrary() {
        return fgXFormsFunctionLibrary;
    }

    public String evaluateAsString(List nodeset, int position, String xpathString, Map prefixMapping, XPathFunctionContext functionContext) throws XFormsException {
        return XPathUtil.getAsString(this.evaluate(nodeset, position, xpathString, prefixMapping, functionContext), 1);
    }

    public String evaluateAsString(BetterFormXPathContext context, String xpathString) throws XFormsException {
        return XPathUtil.getAsString(this.evaluate(context.getNodeset(), context.getPosition(), xpathString, context.getPrefixMapping(), context.getXPathFunctionContext()), 1);
    }

    public Boolean evaluateAsBoolean(BetterFormXPathContext context, String xpathString) throws XFormsException {
        return XPathUtil.getAsBoolean(this.evaluate(context.getNodeset(), context.getPosition(), xpathString, context.getPrefixMapping(), context.getXPathFunctionContext()), 1);
    }

    public Boolean evaluateAsBoolean(List nodeset, int position, String xpathString, Map prefixMapping, XPathFunctionContext functionContext) throws XFormsException {
        return XPathUtil.getAsBoolean(this.evaluate(nodeset, position, xpathString, prefixMapping, functionContext), 1);
    }

    public double evaluateAsDouble(List nodeset, int position, String xpathString, Map prefixMapping, XPathFunctionContext functionContext) throws XFormsException {
        return XPathUtil.getAsDouble(this.evaluate(nodeset, position, xpathString, prefixMapping, functionContext), 1);
    }

    public double evaluateAsDouble(BetterFormXPathContext context, String xpathString) throws XFormsException {
        return XPathUtil.getAsDouble(this.evaluate(context.getNodeset(), context.getPosition(), xpathString, context.getPrefixMapping(), context.getXPathFunctionContext()), 1);
    }

    public List evaluate(BetterFormXPathContext context, String xpathString) throws XFormsException {
        return this.evaluate(context.getNodeset(), context.getPosition(), xpathString, context.getPrefixMapping(), context.getXPathFunctionContext());
    }

    public List evaluate(NodeInfo contextNode, String xpathString, Map prefixMapping, XPathFunctionContext functionContext) throws XFormsException {
        return this.evaluate(Collections.singletonList(contextNode), 1, xpathString, prefixMapping, functionContext);
    }

    public Node evaluateAsSingleNode(List nodeset, int position, String xpath, Map prefixes, XPathFunctionContext functionContext) throws XFormsException {
        NodeInfo node = (NodeInfo)XPathCache.getInstance().evaluate(nodeset, 1, xpath, prefixes, functionContext).get(0);
        return (Node)((DOMNodeWrapper)node).getUnderlyingNode();
    }

    public Node evaluateAsSingleNode(BetterFormXPathContext context, String xpath) throws XFormsException {
        List nodeList = XPathCache.getInstance().evaluate(context, xpath);
        if (nodeList != null && nodeList.size() >= 1) {
            NodeInfo node = (NodeInfo)nodeList.get(0);
            return (Node)((DOMNodeWrapper)node).getUnderlyingNode();
        }
        return null;
    }

    public List evaluate(List nodeset, int position, String xpathString, Map prefixMapping, XPathFunctionContext functionContext) throws XFormsException {
        if (nodeset != null && nodeset.size() < position) {
            return Collections.EMPTY_LIST;
        }
        try {
            XPathExpression exp = this.getXPathExpression(xpathString, prefixMapping, functionContext != null ? functionContext.getXFormsElement().getContainerObject().getConfiguration() : kCONFIG);
            XPathDynamicContext context = exp.createDynamicContext((Item)nodeset.get(position - 1));
            FocusTrackingIterator nodesetIt = new FocusTrackingIterator((SequenceIterator)new ListSequenceIterator(nodeset, position));
            nodesetIt.next();
            context.getXPathContextObject().setCurrentIterator((FocusIterator)nodesetIt);
            context.getXPathContextObject().getController().setUserData((Object)XFormsProcessorImpl.class.toString(), XPathFunctionContext.class.toString(), (Object)functionContext);
            SequenceIterator it = exp.iterate(context);
            int nrOfEntries = (it.getProperties() & 2) != 0 ? ((LastPositionFinder)it).getLength() : -1;
            if (nrOfEntries == 1) {
                return Collections.singletonList(it.next());
            }
            ArrayList<Item> result = new ArrayList<Item>(nrOfEntries > 0 ? nrOfEntries : 20);
            Item item = it.next();
            while (item != null) {
                result.add(item);
                item = it.next();
            }
            return result;
        }
        catch (XPathException e) {
            if (e.getCause() instanceof XFormsException) {
                throw (XFormsException)e.getCause();
            }
            throw new XFormsException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public XPathExpression getXPathExpression(String xpathString, Map prefixMapping, Configuration configuration) throws XPathException {
        XPathEvaluator xpe = new XPathEvaluator(configuration);
        IndependentContext independentContext = (IndependentContext)xpe.getStaticContext();
        independentContext.setDefaultFunctionNamespace("http://www.w3.org/2002/xforms");
        independentContext.setBackwardsCompatibilityMode(true);
        for (Map.Entry entry : prefixMapping.entrySet()) {
            independentContext.declareNamespace((String)entry.getKey(), (String)entry.getValue());
        }
        independentContext.setFunctionLibrary(fgXFormsFunctionLibrary);
        xpe.setStaticContext((XPathStaticContext)independentContext);
        XPathExpression exp = xpe.createExpression(xpathString);
        return exp;
    }

    private IndependentContext createIndependentContext(Map prefixMapping) {
        IndependentContext independentContext = new IndependentContext();
        independentContext.setDefaultFunctionNamespace("http://www.w3.org/2002/xforms");
        independentContext.setBackwardsCompatibilityMode(true);
        for (Map.Entry entry : prefixMapping.entrySet()) {
            independentContext.declareNamespace((String)entry.getKey(), (String)entry.getValue());
        }
        independentContext.setFunctionLibrary(fgXFormsFunctionLibrary);
        return independentContext;
    }

    static {
        fgXPathCache = new XPathCache();
        fgXFormsFunctionLibrary = new FunctionLibraryList();
        fgXFormsFunctionLibrary.addFunctionLibrary((FunctionLibrary)SystemFunctionLibrary.getSystemFunctionLibrary((int)54));
        fgXFormsFunctionLibrary.addFunctionLibrary((FunctionLibrary)new ConstructorFunctionLibrary(kCONFIG));
        fgXFormsFunctionLibrary.addFunctionLibrary((FunctionLibrary)new XFormsFunctionLibrary());
        fgXFormsFunctionLibrary.addFunctionLibrary((FunctionLibrary)new BetterFormFunctionLibrary());
        fgXFormsFunctionLibrary.addFunctionLibrary((FunctionLibrary)new XPathFunctionLibrary());
    }

    private static class ListSequenceIterator
    implements SequenceIterator,
    Cloneable,
    LastPositionFinder,
    LookaheadIterator {
        private List nodeset;
        private int position;

        public ListSequenceIterator(List nodeset, int position) {
            this.nodeset = nodeset;
            this.position = position - 1;
        }

        public Item current() {
            if (this.position != -1) {
                return (NodeInfo)this.nodeset.get(this.position - 1);
            }
            return null;
        }

        public SequenceIterator getAnother() {
            return new ListSequenceIterator(this.nodeset, this.position);
        }

        public Item next() {
            this.position = this.position < this.nodeset.size() ? ++this.position : -1;
            return this.current();
        }

        public int position() {
            return this.position;
        }

        public void close() {
            this.close();
        }

        public int getProperties() {
            return 6;
        }

        public int getLength() throws XPathException {
            return this.nodeset.size();
        }

        public boolean hasNext() {
            return this.position <= this.nodeset.size();
        }
    }
}

