/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xpath.impl.saxon;

import de.betterform.xml.ns.NamespaceResolver;
import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xforms.xpath.saxon.function.XPathFunctionContext;
import de.betterform.xml.xpath.impl.saxon.XPathCache;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.saxon.dom.DOMNodeWrapper;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathUtil {
    public static String getAsString(List nodeset, int position) {
        List resultAsNodeset = nodeset;
        if (resultAsNodeset.size() >= position) {
            return ((Item)resultAsNodeset.get(position - 1)).getStringValue();
        }
        return null;
    }

    public static boolean getAsBoolean(List nodeset, int position) {
        if (nodeset.size() > position) {
            return false;
        }
        Item item = (Item)nodeset.get(position - 1);
        if (item instanceof BooleanValue) {
            return ((BooleanValue)item).effectiveBooleanValue();
        }
        return false;
    }

    public static double getAsDouble(List nodeset, int position) {
        if (nodeset.size() > position) {
            return Double.NaN;
        }
        Item item = (Item)nodeset.get(position - 1);
        if (item instanceof DoubleValue) {
            return ((DoubleValue)item).getDoubleValue();
        }
        return Double.NaN;
    }

    public static boolean existsNode(List contextNodeset, int positionInNodeset, String path, Map prefixMapping, XPathFunctionContext functionContext) throws XFormsException {
        return XPathCache.getInstance().evaluate(contextNodeset, positionInNodeset, path, prefixMapping, functionContext).size() > 0;
    }

    public static Node getAsNode(List nodeset, int position) {
        Item item;
        List resultAsNodeset = nodeset;
        if (resultAsNodeset.size() >= position && (item = (Item)resultAsNodeset.get(position - 1)) instanceof DOMNodeWrapper) {
            return (Node)((DOMNodeWrapper)item).getUnderlyingNode();
        }
        return null;
    }

    public static List getRootContext(Document doc, String baseURI) {
        Element documentElement = doc.getDocumentElement();
        if (documentElement != null) {
            return Collections.singletonList(new DocumentWrapper((Node)doc, baseURI, new IndependentContext().getConfiguration()).wrap((Node)documentElement));
        }
        return Collections.EMPTY_LIST;
    }

    public static List getElementContext(Element element, String baseURI) {
        if (element != null) {
            return Collections.singletonList(new DocumentWrapper((Node)element.getOwnerDocument(), baseURI, new IndependentContext().getConfiguration()).wrap((Node)element));
        }
        return Collections.EMPTY_LIST;
    }

    public static Node evaluateAsSingleNode(Document doc, String xpath, String baseURI) throws XFormsException {
        List context = XPathUtil.getRootContext(doc, baseURI);
        Map namespaces = NamespaceResolver.getAllNamespaces(doc.getDocumentElement());
        return XPathCache.getInstance().evaluateAsSingleNode(context, 1, xpath, namespaces, null);
    }

    public static Node evaluateAsSingleNode(Document doc, String xpath) throws XFormsException {
        return XPathUtil.evaluateAsSingleNode(doc, xpath, "");
    }

    public static List evaluate(Document doc, String xpath) throws XFormsException {
        return XPathUtil.evaluate(doc.getDocumentElement(), xpath);
    }

    public static List evaluate(Element element, String xpath) throws XFormsException {
        List context = XPathUtil.getElementContext(element, null);
        Map namespaces = NamespaceResolver.getAllNamespaces(element);
        NodeInfo root = (NodeInfo)context.get(0);
        return XPathCache.getInstance().evaluate(root, xpath, namespaces, null);
    }

    public static String evaluateAsString(Document doc, String xpath) throws XFormsException {
        List context = XPathUtil.getRootContext(doc, null);
        NamespaceResolver.init(doc.getDocumentElement());
        Map namespaces = NamespaceResolver.getAllNamespaces(doc.getDocumentElement());
        return XPathCache.getInstance().evaluateAsString(context, 1, xpath, namespaces, null);
    }

    public static String evaluateAsString(Element element, String xpath) throws XFormsException {
        List context = XPathUtil.getElementContext(element, null);
        NamespaceResolver.init(element);
        Map namespaces = NamespaceResolver.getAllNamespaces(element);
        return XPathCache.getInstance().evaluateAsString(context, 1, xpath, namespaces, null);
    }
}

