/*
 * Decompiled with CFR 0.152.
 */
package de.betterform.xml.xslt.impl;

import de.betterform.xml.xforms.exception.XFormsException;
import de.betterform.xml.xslt.impl.ClassPathResource;
import de.betterform.xml.xslt.impl.Resource;
import de.betterform.xml.xslt.impl.ResourceResolver;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClasspathResourceResolver
implements ResourceResolver {
    private static final Logger logger = Logger.getLogger(ClasspathResourceResolver.class.getName());
    private static final String RESOURCE_PATH = "/META-INF/resources/xslt/";
    private String realPath;

    public ClasspathResourceResolver(String realPath) {
        this.realPath = realPath;
    }

    @Override
    public Resource resolve(URI uri) throws XFormsException {
        if (!uri.toString().endsWith(".xsl")) {
            return null;
        }
        String uriString = uri.toString();
        String filename = uriString.substring(uriString.lastIndexOf("/") + 1);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "file: " + filename + " loaded from classpath");
        }
        InputStream inputStream = ClasspathResourceResolver.class.getResourceAsStream(RESOURCE_PATH + filename);
        return new ClassPathResource(inputStream);
    }
}

