/*
 * Decompiled with CFR 0.152.
 */
package org.exist.contentextraction.xquery;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.exist.contentextraction.ContentExtraction;
import org.exist.contentextraction.ContentExtractionException;
import org.exist.contentextraction.ContentReceiver;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.stax.ExtendedXMLStreamReader;
import org.exist.storage.NodePath;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ContentFunctions
extends BasicFunction {
    public static final FunctionSignature getMeatadata = new FunctionSignature(new QName("get-metadata", "http://exist-db.org/xquery/contentextraction", "contentextraction"), "extracts the metadata", new SequenceType[]{new FunctionParameterSequenceType("binary", 26, 2, "The binary data to extract from")}, (SequenceType)new FunctionReturnSequenceType(6, 2, "Extracted metadata"));
    public static final FunctionSignature getMetadataAndContent = new FunctionSignature(new QName("get-metadata-and-content", "http://exist-db.org/xquery/contentextraction", "contentextraction"), "extracts the metadata and contents", new SequenceType[]{new FunctionParameterSequenceType("binary", 26, 2, "The binary data to extract from")}, (SequenceType)new FunctionReturnSequenceType(6, 2, "Extracted content and metadata"));
    public static final FunctionSignature streamContent = new FunctionSignature(new QName("stream-content", "http://exist-db.org/xquery/contentextraction", "contentextraction"), "extracts the metadata", new SequenceType[]{new FunctionParameterSequenceType("binary", 26, 2, "The binary data to extract from"), new FunctionParameterSequenceType("paths", 22, 7, "A sequence of (simple) node paths which should be passed to the callback function"), new FunctionParameterSequenceType("callback", 101, 2, "The callback function. Expected signature: callback($node as node(), $userData as item()*, $retValue as item()*),where $node is the currently processed node, $userData contains the data supplied in the $userData parameter of stream-content, and $retValue is the return value of the previous call to the callback function. The last two parameters are used for passing information between the calling function and subsequent invocations of the callback function."), new FunctionParameterSequenceType("namespaces", 1, 3, "Prefix/namespace mappings to be used for matching the paths. Pass an XML fragment with the following structure: <namespaces><namespace prefix=\"prefix\" uri=\"uri\"/></namespaces>."), new FunctionParameterSequenceType("userData", 11, 7, "Additional data which will be passed to the callback function.")}, (SequenceType)new FunctionReturnSequenceType(10, 1, "Returns empty sequence"));

    public ContentFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ContentExtraction ce = new ContentExtraction();
        if (this.isCalledAs("stream-content")) {
            BinaryValue binary = (BinaryValue)args[0].itemAt(0);
            FunctionReference ref = (FunctionReference)args[2].itemAt(0);
            HashMap<String, String> mappings = new HashMap<String, String>();
            if (args[3].hasOne()) {
                NodeValue namespaces = (NodeValue)args[3].itemAt(0);
                this.parseMappings(namespaces, mappings);
            }
            return this.streamContent(ce, binary, args[1], ref, mappings, args[4]);
        }
        try {
            DocumentBuilderReceiver builder = new DocumentBuilderReceiver();
            builder.setSuppressWhitespace(false);
            if (this.isCalledAs("get-metadata")) {
                ce.extractMetadata((BinaryValue)args[0].itemAt(0), (ContentHandler)builder);
            } else {
                ce.extractContentAndMetadata((BinaryValue)args[0].itemAt(0), (ContentHandler)builder);
            }
            return (NodeValue)builder.getDocument();
        }
        catch (IOException | ContentExtractionException | SAXException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new XPathException((Expression)this, ex.getMessage(), (Throwable)ex);
        }
    }

    private void parseMappings(NodeValue namespaces, Map<String, String> mappings) throws XPathException {
        try {
            ExtendedXMLStreamReader reader = this.context.getXMLStreamReader(namespaces);
            reader.next();
            while (reader.hasNext()) {
                int status = reader.next();
                if (status != 1 || !reader.getLocalName().equals("namespace")) continue;
                String prefix = reader.getAttributeValue("", "prefix");
                String uri = reader.getAttributeValue("", "uri");
                mappings.put(prefix, uri);
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new XPathException((Expression)this, "Error while parsing namespace mappings: " + e.getMessage(), (Throwable)e);
        }
    }

    private Sequence streamContent(ContentExtraction ce, BinaryValue binary, Sequence pathSeq, FunctionReference ref, Map<String, String> mappings, Sequence data) throws XPathException {
        NodePath[] paths = new NodePath[pathSeq.getItemCount()];
        int i = 0;
        SequenceIterator iter = pathSeq.iterate();
        while (iter.hasNext()) {
            String path = iter.nextItem().getStringValue();
            paths[i] = new NodePath(mappings, path, false);
            ++i;
        }
        ContentReceiver receiver = new ContentReceiver(this.context, paths, ref, data);
        try {
            ce.extractContentAndMetadata(binary, receiver);
        }
        catch (IOException | ContentExtractionException | SAXException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new XPathException((Expression)this, ex.getMessage(), (Throwable)ex);
        }
        return receiver.getResult();
    }
}

