/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.fit.internal.LegacySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static List<Field> getFields(Object aObject) {
        return ReflectionUtil.getFields(aObject.getClass());
    }

    public static List<Field> getFields(Class<?> aClass) {
        Class<?> cls = aClass;
        ArrayList<Field> fields = new ArrayList<Field>();
        while (!cls.equals(Object.class)) {
            Field[] flds = cls.getDeclaredFields();
            fields.addAll(Arrays.asList(flds));
            cls = cls.getSuperclass();
        }
        return fields;
    }

    public static Field getField(Object aObject, String aName) throws NoSuchFieldException {
        return ReflectionUtil.getField(aObject.getClass(), aName);
    }

    public static Field getField(Class<?> aClass, String aName) throws NoSuchFieldException {
        try {
            return aClass.getDeclaredField(aName);
        }
        catch (NoSuchFieldException e) {
            if (aClass.getSuperclass() == null) {
                throw e;
            }
            return ReflectionUtil.getField(aClass.getSuperclass(), aName);
        }
    }

    public static <T extends Annotation> T getInheritableAnnotation(Class<T> aAnnotation, Class<?> aClass) {
        if (ReflectionUtil.isAnnotationPresent(aClass, aAnnotation)) {
            return ReflectionUtil.getAnnotation(aClass, aAnnotation);
        }
        if (aClass.getSuperclass() != null) {
            return ReflectionUtil.getInheritableAnnotation(aAnnotation, aClass.getSuperclass());
        }
        return null;
    }

    public static boolean isAnnotationPresent(AccessibleObject aObject, Class<? extends Annotation> aAnnotationClass) {
        if (aObject.getAnnotation(aAnnotationClass) != null) {
            return true;
        }
        return LegacySupport.getInstance().isAnnotationPresent(aObject, aAnnotationClass);
    }

    public static boolean isAnnotationPresent(Class<?> aObject, Class<? extends Annotation> aAnnotationClass) {
        if (aObject.getAnnotation(aAnnotationClass) != null) {
            return true;
        }
        return LegacySupport.getInstance().isAnnotationPresent(aObject, aAnnotationClass);
    }

    public static <T extends Annotation> T getAnnotation(AccessibleObject aObject, Class<T> aAnnotationClass) {
        T annotation = aObject.getAnnotation(aAnnotationClass);
        if (annotation == null) {
            annotation = LegacySupport.getInstance().getAnnotation(aObject, aAnnotationClass);
        }
        return annotation;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> aObject, Class<T> aAnnotationClass) {
        T annotation = aObject.getAnnotation(aAnnotationClass);
        if (annotation == null) {
            annotation = LegacySupport.getInstance().getAnnotation(aObject, aAnnotationClass);
        }
        return annotation;
    }
}

