/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal;

import java.net.MalformedURLException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.springframework.util.ClassUtils;

public class ResourceManagerFactory {
    private static ResourceManagerCreator resourceManagerCreator = new DefaultResourceManagerCreator();

    private ResourceManagerFactory() {
    }

    public static ResourceManager newResourceManager() throws ResourceInitializationException {
        return resourceManagerCreator.newResourceManager();
    }

    public static synchronized void setResourceManagerCreator(ResourceManagerCreator resourceManagerCreator) {
        ResourceManagerFactory.resourceManagerCreator = resourceManagerCreator;
    }

    public static ResourceManagerCreator getResourceManagerCreator() {
        return resourceManagerCreator;
    }

    public static class DefaultResourceManagerCreator
    implements ResourceManagerCreator {
        public ResourceManager newResourceManager() throws ResourceInitializationException {
            try {
                ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
                resMgr.setExtensionClassPath(ClassUtils.getDefaultClassLoader(), "", true);
                return resMgr;
            }
            catch (MalformedURLException e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    public static interface ResourceManagerCreator {
        public ResourceManager newResourceManager() throws ResourceInitializationException;
    }
}

