/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ctakes.core.util.ParamUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;

public class CopyAnnotator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_SOURCE_CLASS = "srcObjClass";
    @ConfigurationParameter(name="srcObjClass", mandatory=true, description="Name of source class")
    private String srcClassName;
    public static final String PARAM_DEST_CLASS = "destObjClass";
    @ConfigurationParameter(name="destObjClass", mandatory=true, description="Name of destination class")
    private String destClassName;
    public static final String PARAM_METHOD_MAP = "dataBindMap";
    @ConfigurationParameter(name="dataBindMap", mandatory=true, description="Mapping between source methods and destination methods in a bar (\"|\") separated format")
    private String[] methodMapArray;
    private Class<? extends TOP> srcClass;
    private Logger logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    private Constructor<?> iv_destContr;
    private Map<Method, Method> iv_getSetMap;

    public void initialize(UimaContext annotCtx) throws ResourceInitializationException {
        super.initialize(annotCtx);
        try {
            this.srcClass = Class.forName(this.srcClassName);
            if (!TOP.class.isAssignableFrom(this.srcClass)) {
                throw new ResourceInitializationException();
            }
            Class<?> destClass = Class.forName(this.destClassName);
            Class[] constrArgs = new Class[]{JCas.class};
            this.iv_destContr = destClass.getConstructor(constrArgs);
            Map<String, String> m = ParamUtil.getStringParameterValuesMap(this.methodMapArray, "|");
            this.iv_getSetMap = new HashMap<Method, Method>();
            for (String getterMethName : m.keySet()) {
                String setterMethName = m.get(getterMethName);
                Method getterMeth = this.srcClass.getMethod(getterMethName, null);
                Class[] setterArgs = new Class[]{getterMeth.getReturnType()};
                Method setterMeth = destClass.getMethod(setterMethName, setterArgs);
                this.iv_getSetMap.put(getterMeth, setterMeth);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.logger.info((Object)"process(JCas)");
        Collection srcObjs = JCasUtil.select((JCas)jcas, this.srcClass);
        for (TOP srcObj : srcObjs) {
            Object[] constrArgVals = new Object[]{jcas};
            try {
                TOP destObj = (TOP)this.iv_destContr.newInstance(constrArgVals);
                for (Method getterMeth : this.iv_getSetMap.keySet()) {
                    Method setterMeth = this.iv_getSetMap.get(getterMeth);
                    Object val = getterMeth.invoke((Object)srcObj, (Object[])null);
                    Object[] setterArgs = new Object[]{val};
                    setterMeth.invoke((Object)destObj, setterArgs);
                }
                destObj.addToIndexes();
            }
            catch (Exception e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
        }
    }
}

