/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.ae;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.ctakes.core.util.JCasUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;

public class OverlapAnnotator
extends JCasAnnotator_ImplBase {
    private Logger iv_logger = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    public static final byte OVERLAP_NONE = 0;
    public static final byte OVERLAP_PARTIAL = 1;
    public static final byte OVERLAP_EXACT = 2;
    public static final byte OVERLAP_A_ENV_B = 3;
    public static final byte OVERLAP_B_ENV_A = 4;
    private final int NUM_OVERLAP_BITS = 5;
    private BitSet iv_typesOfOverlapToProcess;
    private int iv_aAnnotType;
    private int iv_bAnnotType;
    private Action iv_action;

    public void initialize(UimaContext annotCtx) throws ResourceInitializationException {
        block4: {
            super.initialize(annotCtx);
            try {
                String classname = (String)annotCtx.getConfigParameterValue("A_ObjectClass");
                this.iv_aAnnotType = JCasUtil.getType(classname);
                classname = (String)annotCtx.getConfigParameterValue("B_ObjectClass");
                this.iv_bAnnotType = JCasUtil.getType(classname);
                String overlapTypeStr = (String)annotCtx.getConfigParameterValue("OverlapType");
                this.parseOverlapTypeString(overlapTypeStr);
                String actionTypeStr = (String)annotCtx.getConfigParameterValue("ActionType");
                if (actionTypeStr.equalsIgnoreCase("MODIFY")) {
                    String[] argArr = (String[])annotCtx.getConfigParameterValue("ModifyAction");
                    this.iv_action = this.buildModifyAction(argArr);
                    break block4;
                }
                if (actionTypeStr.equalsIgnoreCase("DELETE")) {
                    String[] argArr = (String[])annotCtx.getConfigParameterValue("DeleteAction");
                    this.iv_action = this.buildDeleteAction(argArr);
                    break block4;
                }
                throw new Exception("Invalid action type: " + actionTypeStr);
            }
            catch (Exception e) {
                throw new ResourceInitializationException((Throwable)e);
            }
        }
    }

    private void parseOverlapTypeString(String str) throws Exception {
        this.iv_typesOfOverlapToProcess = new BitSet(5);
        StringTokenizer st = new StringTokenizer(str, "|");
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equalsIgnoreCase("NONE")) {
                this.iv_typesOfOverlapToProcess.set(0, true);
                continue;
            }
            if (tok.equalsIgnoreCase("PARTIAL")) {
                this.iv_typesOfOverlapToProcess.set(1, true);
                continue;
            }
            if (tok.equalsIgnoreCase("EXACT")) {
                this.iv_typesOfOverlapToProcess.set(2, true);
                continue;
            }
            if (tok.equalsIgnoreCase("A_ENV_B")) {
                this.iv_typesOfOverlapToProcess.set(3, true);
                continue;
            }
            if (tok.equalsIgnoreCase("B_ENV_A")) {
                this.iv_typesOfOverlapToProcess.set(4, true);
                continue;
            }
            throw new Exception("Invalid overlap type: " + tok);
        }
        if (this.iv_typesOfOverlapToProcess.get(0) && this.iv_typesOfOverlapToProcess.cardinality() > 1) {
            throw new Exception("NONE overlap type is exclusive and cannot be combined with other types.");
        }
        if (this.iv_logger.isDebugEnabled()) {
            this.iv_logger.debug((Object)("Overlap bitset: " + this.iv_typesOfOverlapToProcess));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Action buildModifyAction(String[] argArr) throws Exception {
        int endSrc;
        byte beginSrc;
        byte selector;
        String selectorStr = null;
        String beginStr = null;
        String endStr = null;
        for (int i = 0; i < argArr.length; ++i) {
            StringTokenizer st = new StringTokenizer(argArr[i], "=");
            String key = st.nextToken();
            String val = st.nextToken();
            if (key.equalsIgnoreCase("selector")) {
                selectorStr = val;
                continue;
            }
            if (key.equalsIgnoreCase("begin")) {
                beginStr = val;
                continue;
            }
            if (!key.equalsIgnoreCase("end")) continue;
            endStr = val;
        }
        if (selectorStr == null) throw new Exception("ModifyAction selector not specified.");
        if (selectorStr.equalsIgnoreCase("A")) {
            selector = 0;
        } else {
            if (!selectorStr.equalsIgnoreCase("B")) throw new Exception("ModifyAction selector invalid: " + selectorStr);
            selector = 1;
        }
        if (beginStr == null) throw new Exception("ModifyAction begin not specified.");
        if (beginStr.equalsIgnoreCase("A")) {
            beginSrc = 0;
        } else if (beginStr.equalsIgnoreCase("B")) {
            beginSrc = 1;
        } else if (beginStr.equalsIgnoreCase("SMALLEST")) {
            beginSrc = 2;
        } else {
            if (!beginStr.equalsIgnoreCase("LARGEST")) throw new Exception("ModifyAction begin invalid: " + beginStr);
            beginSrc = 3;
        }
        if (endStr == null) throw new Exception("ModifyAction end not specified.");
        if (endStr.equalsIgnoreCase("A")) {
            endSrc = 0;
            return new ModifyActionImpl(selector, beginSrc, (byte)endSrc);
        } else if (endStr.equalsIgnoreCase("B")) {
            endSrc = 1;
            return new ModifyActionImpl(selector, beginSrc, (byte)endSrc);
        } else if (endStr.equalsIgnoreCase("SMALLEST")) {
            endSrc = 2;
            return new ModifyActionImpl(selector, beginSrc, (byte)endSrc);
        } else {
            if (!endStr.equalsIgnoreCase("LARGEST")) throw new Exception("ModifyAction end invalid: " + endStr);
            endSrc = 3;
        }
        return new ModifyActionImpl(selector, beginSrc, (byte)endSrc);
    }

    private Action buildDeleteAction(String[] argArr) throws Exception {
        String selectorStr = null;
        for (int i = 0; i < argArr.length; ++i) {
            StringTokenizer st = new StringTokenizer(argArr[i], "=");
            String key = st.nextToken();
            String val = st.nextToken();
            if (!key.equalsIgnoreCase("selector")) continue;
            selectorStr = val;
        }
        if (selectorStr != null) {
            int selector;
            if (selectorStr.equalsIgnoreCase("A")) {
                selector = 0;
            } else if (selectorStr.equalsIgnoreCase("B")) {
                selector = 1;
            } else if (selectorStr.equalsIgnoreCase("BOTH")) {
                selector = 2;
            } else {
                throw new Exception("DeleteAction selector invalid: " + selectorStr);
            }
            return new DeleteActionImpl((byte)selector);
        }
        throw new Exception("DeleteAction selector not specified.");
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        this.iv_logger.info((Object)"process(JCas)");
        JFSIndexRepository indexes = jcas.getJFSIndexRepository();
        List<Annotation> aAnnotList = this.storeAnnotationsToList(indexes, this.iv_aAnnotType);
        List<Annotation> bAnnotList = this.storeAnnotationsToList(indexes, this.iv_bAnnotType);
        for (Annotation aAnnot : aAnnotList) {
            for (Annotation bAnnot : bAnnotList) {
                BitSet jcasOverlapType = this.getOverlapType(aAnnot, bAnnot);
                jcasOverlapType.and(this.iv_typesOfOverlapToProcess);
                if (jcasOverlapType.cardinality() <= 0) continue;
                this.iv_action.performAction(aAnnot, bAnnot);
            }
        }
    }

    private List<Annotation> storeAnnotationsToList(JFSIndexRepository indexes, int annotType) {
        ArrayList<Annotation> l = new ArrayList<Annotation>();
        for (Annotation annot : indexes.getAnnotationIndex(annotType)) {
            l.add(annot);
        }
        return l;
    }

    private BitSet getOverlapType(Annotation a, Annotation b) {
        BitSet bitSet = new BitSet(5);
        if (a.getBegin() == b.getBegin() && a.getEnd() == b.getEnd()) {
            bitSet.set(2, true);
            return bitSet;
        }
        if (a.getBegin() <= b.getBegin() && a.getEnd() >= b.getEnd()) {
            bitSet.set(3, true);
            return bitSet;
        }
        if (b.getBegin() <= a.getBegin() && b.getEnd() >= a.getEnd()) {
            bitSet.set(4, true);
            return bitSet;
        }
        if (a.getBegin() < b.getBegin() && a.getEnd() > b.getBegin() && a.getEnd() < b.getEnd()) {
            bitSet.set(1, true);
            return bitSet;
        }
        if (b.getBegin() < a.getBegin() && b.getEnd() > a.getBegin() && b.getEnd() < a.getEnd()) {
            bitSet.set(1, true);
            return bitSet;
        }
        bitSet.set(0, true);
        return bitSet;
    }

    class DeleteActionImpl
    implements Action {
        public static final byte SELECT_A = 0;
        public static final byte SELECT_B = 1;
        public static final byte SELECT_A_B = 2;
        private byte iv_selector;

        public DeleteActionImpl(byte selector) {
            this.iv_selector = selector;
        }

        @Override
        public void performAction(Annotation aAnnot, Annotation bAnnot) {
            if (this.iv_selector == 0) {
                aAnnot.removeFromIndexes();
            } else if (this.iv_selector == 1) {
                bAnnot.removeFromIndexes();
            } else {
                aAnnot.removeFromIndexes();
                bAnnot.removeFromIndexes();
            }
        }
    }

    class ModifyActionImpl
    implements Action {
        public static final byte SELECT_A = 0;
        public static final byte SELECT_B = 1;
        private byte iv_selector;
        private static final byte BEGIN_A = 0;
        private static final byte BEGIN_B = 1;
        private static final byte BEGIN_SMALLEST = 2;
        private static final byte BEGIN_LARGEST = 3;
        private byte iv_beginSrc;
        private static final byte END_A = 0;
        private static final byte END_B = 1;
        private static final byte END_SMALLEST = 2;
        private static final byte END_LARGEST = 3;
        private byte iv_endSrc;

        public ModifyActionImpl(byte selector, byte beginSrc, byte endSrc) {
            this.iv_selector = selector;
            this.iv_beginSrc = beginSrc;
            this.iv_endSrc = endSrc;
        }

        @Override
        public void performAction(Annotation aAnnot, Annotation bAnnot) {
            Annotation ann = null;
            ann = this.iv_selector == 0 ? aAnnot : bAnnot;
            this.modifyBegin(ann, aAnnot, bAnnot);
            this.modifyEnd(ann, aAnnot, bAnnot);
        }

        private void modifyBegin(Annotation ann, Annotation aAnnot, Annotation bAnnot) {
            switch (this.iv_beginSrc) {
                case 0: {
                    ann.setBegin(aAnnot.getBegin());
                    break;
                }
                case 1: {
                    ann.setBegin(bAnnot.getBegin());
                    break;
                }
                case 2: {
                    ann.setBegin(Math.min(aAnnot.getBegin(), bAnnot.getBegin()));
                    break;
                }
                case 3: {
                    ann.setBegin(Math.max(aAnnot.getBegin(), bAnnot.getBegin()));
                }
            }
        }

        private void modifyEnd(Annotation ann, Annotation aAnnot, Annotation bAnnot) {
            switch (this.iv_endSrc) {
                case 0: {
                    ann.setEnd(aAnnot.getEnd());
                    break;
                }
                case 1: {
                    ann.setEnd(bAnnot.getEnd());
                    break;
                }
                case 2: {
                    ann.setEnd(Math.min(aAnnot.getEnd(), bAnnot.getEnd()));
                    break;
                }
                case 3: {
                    ann.setEnd(Math.max(aAnnot.getEnd(), bAnnot.getEnd()));
                }
            }
        }
    }

    static interface Action {
        public void performAction(Annotation var1, Annotation var2);
    }
}

