/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.ctakes.core.util.DocumentIDAnnotationUtil;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;

public class FilesInDirectoryCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUTDIR = "OutputDirectory";
    File iv_outputDirectory;

    public void initialize() throws ResourceInitializationException {
        String outputDirectoryName = (String)this.getConfigParameterValue(PARAM_OUTPUTDIR);
        this.iv_outputDirectory = new File(outputDirectoryName);
        if (!this.iv_outputDirectory.exists() || !this.iv_outputDirectory.isDirectory()) {
            throw new ResourceInitializationException((Throwable)new Exception("Parameter setting 'OutputDirectory' does not point to an existing directory."));
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = cas.getJCas();
            String documentID = DocumentIDAnnotationUtil.getDocumentID(jcas);
            String documentText = jcas.getDocumentText();
            if (documentID == null && (documentID = DocumentIDAnnotationUtil.getDocumentID(jcas = cas.getJCas().getView("_InitialView"))) == null && (documentID = DocumentIDAnnotationUtil.getDocumentID(jcas = cas.getJCas().getView("plaintext"))) == null) {
                documentID = "doc_" + new Date().getTime() + ".xml";
                System.err.println("Unable to find DocumentIDAnnotation, using " + documentID);
            }
            this.writeToFile(documentID, documentText);
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
    }

    private void writeToFile(String documentID, String documentText) throws IOException {
        File outputFile = new File(this.iv_outputDirectory, documentID);
        outputFile.createNewFile();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
        ((OutputStream)out).write(documentText.getBytes());
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }
}

