/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.cr;

import java.io.IOException;
import org.apache.ctakes.core.cr.FilesInDirectoryCollectionReader;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

public class FilesInDirectoryCollectionCyclicalReads
extends FilesInDirectoryCollectionReader {
    public static final String PARAM_INPUTDIR = "InputDirectory";
    public static final String PARAM_ENCODING = "Encoding";
    public static final String PARAM_LANGUAGE = "Language";
    public static final String PARAM_EXTENSIONS = "Extensions";
    public static final String PARAM_NUMREADS = "NumberOfIterations";
    public static final String PARAM_RECURSE = "Recurse";
    private int iv_iteration;
    private int scaleTime;
    private int totalNumFiles;
    private int remainTimes;

    @Override
    public void initialize() throws ResourceInitializationException {
        super.initialize();
        this.totalNumFiles = this.iv_files.size();
        this.iv_iteration = (Integer)this.getConfigParameterValue(PARAM_NUMREADS);
        if (this.iv_iteration > this.totalNumFiles) {
            this.scaleTime = this.iv_iteration / this.totalNumFiles;
            this.remainTimes = this.iv_iteration % this.totalNumFiles;
        } else {
            this.scaleTime = -1;
        }
    }

    @Override
    public boolean hasNext() {
        boolean doNext;
        boolean bl = doNext = this.iv_currentIndex < this.totalNumFiles;
        if (!doNext && this.scaleTime > 0) {
            --this.scaleTime;
            if (this.scaleTime > 0) {
                this.iv_currentIndex = 0;
                doNext = true;
            } else if (this.remainTimes > 0) {
                this.iv_currentIndex = 0;
                this.totalNumFiles = this.remainTimes;
                this.remainTimes = 0;
                doNext = true;
            }
        }
        if (this.scaleTime == -1) {
            doNext = this.iv_currentIndex < this.iv_iteration;
        }
        return doNext;
    }

    @Override
    public void getNext(CAS aCAS) throws IOException, CollectionException {
        super.getNext(aCAS);
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public Progress[] getProgress() {
        int offSet = this.iv_currentIndex;
        if (this.scaleTime > 0 && this.iv_currentIndex > 0) {
            offSet = this.iv_currentIndex * (1 / this.scaleTime);
        }
        if (this.scaleTime == 0) {
            offSet = this.iv_iteration + this.remainTimes;
        }
        return new Progress[]{new ProgressImpl(offSet, this.iv_iteration, "entities")};
    }

    @Override
    public int getNumberOfDocuments() {
        return this.iv_files.size();
    }
}

